package fr.toutatice.cartoun.plugin.theming;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.cms.EcmDocument;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.theming.TabGroup;

/**
 * Cartography tab group.
 *
 * @author Cédric Krommenhoek
 * @see TabGroup
 */
public class CartographyTabGroup implements TabGroup {

    /** Group name. */
    private static final String NAME = "cartography";
    /** Group icon. */
    private static final String ICON = "halflings halflings-map-marker";
    /** Group label internationalization key. */
    private static final String LABEL_KEY = "CARTOGRAPHY";

    private final IDirectoryService directoryService;

    /**
     * Constructor.
     */
    public CartographyTabGroup(IDirectoryService directoryService) {
        super();
        this.directoryService = directoryService;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getName() {
        return NAME;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getIcon() {
        return ICON;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getLabelKey() {
        return LABEL_KEY;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public boolean contains(PortalControllerContext portalControllerContext, EcmDocument document, String type, Map<String, String> pageProperties) {
        return document != null;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public boolean maintains(PortalControllerContext portalControllerContext, EcmDocument document, String type, Map<String, String> pageProperties) {
        boolean maintains;

        if (document instanceof Document) {
            final HttpServletRequest httpServletRequest = portalControllerContext.getHttpServletRequest();

            String webIdACA = (String) httpServletRequest.getSession().getAttribute("webIdACA");
            if (webIdACA == null) {
                // get codeACA
                final String uid = httpServletRequest.getUserPrincipal().getName();
                final DirectoryPerson person = directoryService.getPerson(uid);
                final String academy = (String) person.getExtraProperties().get("codeAcademie");

                // build webId
                webIdACA = "sun_" + academy;
                // set webIdACA in session attribute
                httpServletRequest.getSession().setAttribute("webIdACA", webIdACA);
            }

            final Document nuxeoDocument = (Document) document;
            maintains = StringUtils.equals(webIdACA, nuxeoDocument.getString("ttc:webid"));

        } else {
            maintains = false;
        }
        return maintains;
    }

}
