package fr.toutatice.cartoun.customizer.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;


public class CustomToolbarAttributesBundle implements IAttributesBundle {

    /** DISCIPLINES_PAGE_URL */
    private final static String DISCIPLINES_PAGE_URL = "acrennes.sites.cartoun.disciplinesPage.url";

    /** Portal URL factory. */
    private final IPortalUrlFactory urlFactory;
    /** Toolbar attributes names. */
    private final Set<String> names;

    /**
     * Singleton Holder
     */
    private static class CustomToolbarAttributesBundleHolder {

        private static final CustomToolbarAttributesBundle INSTANCE = new CustomToolbarAttributesBundle();
    }

    /**
     * Singleton instance access.
     *
     * @return singleton instance
     */
    public static CustomToolbarAttributesBundle getInstance() {
        return CustomToolbarAttributesBundleHolder.INSTANCE;
    }

    /**
     * Constructor
     */
    private CustomToolbarAttributesBundle() {
        // URL factory
        urlFactory = Locator.findMBean(IPortalUrlFactory.class, IPortalUrlFactory.MBEAN_NAME);
        names = new TreeSet<String>();
        names.add(DISCIPLINES_PAGE_URL);
    }

    @Override
    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        final ControllerContext controllerContext = renderPageCommand.getControllerContext();
        final PortalControllerContext portalControllerContext = new PortalControllerContext(controllerContext);

        String disciplinesPageUrl;
        try {
            final Map<String, String> map = new HashMap<String, String>();
            disciplinesPageUrl = urlFactory.getStartPageUrl(portalControllerContext, "Mes Disciplines", "/cartoun/templates/disciplines", map, map);
        } catch (final PortalException e) {
            throw new ControllerException(e);
        }
        attributes.put(DISCIPLINES_PAGE_URL, disciplinesPageUrl);
    }

    @Override
    public Set<String> getAttributeNames() {
        return names;
    }

}
