package fr.toutatice.cartoun.customizer.attributes;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;

/**
 * Footer attributes bundle.
 *
 * @author Cédric Krommenhoek
 * @see IAttributesBundle
 */
public class FooterAttributesBundle implements IAttributesBundle {

    /** Legal notices URL attribute name. */
    private static final String LEGAL_NOTICES_URL_ATTRIBUTE = "acrennes.legal-notices.url";


    /** Singleton instance. */
    private static IAttributesBundle instance;


    /** Log. */
    private final Log log;

    /** Portal URL factory. */
    private final IPortalUrlFactory portalURLFactory;

    /** Attribute names. */
    private final Set<String> names;


    /**
     * Private constructor.
     */
    private FooterAttributesBundle() {
        super();
        this.log = LogFactory.getLog(getClass());

        // Portal URL factory
        this.portalURLFactory = Locator.findMBean(IPortalUrlFactory.class, IPortalUrlFactory.MBEAN_NAME);

        this.names = new TreeSet<String>();
        this.names.add(LEGAL_NOTICES_URL_ATTRIBUTE);
    }


    /**
     * Get singleton instance.
     *
     * @return singleton instance
     */
    public static IAttributesBundle getInstance() {
        if (instance == null) {
            instance = new FooterAttributesBundle();
        }
        return instance;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        // Controller context
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        // Portal controller context
        PortalControllerContext portalControllerContext = new PortalControllerContext(controllerContext);

        Map<String, String> emptyMap = new HashMap<String, String>(0);

        // Legal Notices URL
        try {
            String legalNoticesURL = this.portalURLFactory.getStartPageUrl(portalControllerContext, "mentionslegales",
 "/default/templates/mentionslegales",
                    emptyMap, emptyMap);
            attributes.put(LEGAL_NOTICES_URL_ATTRIBUTE, legalNoticesURL);
        } catch (PortalException e) {
            log.warn("Unable to get legal notices page URL.", e);
        }
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Set<String> getAttributeNames() {
        return this.names;
    }

}
