package fr.toutatice.cartoun.plugin.fragment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;

import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import fr.toutatice.portail.cms.nuxeo.api.fragment.FragmentModule;

/**
 * Clean selectors fragment module.
 *
 * @author jeanseb
 * @see IFragmentModule
 */
public class CleanSelectorsFragmentModule extends FragmentModule {

    /** Clean URL attribute name. */
    private static final String CLEAN_URL = "cleanUrl";

    /**
     * Constructor.
     *
     * @param portletContext portlet context
     */
    public CleanSelectorsFragmentModule(PortletContext portletContext) {
        super(portletContext);
    }


    /**
     * Récupération du service d'URL.
     */
    public IPortalUrlFactory getPortalUrlFactory(PortletContext portletCtx) throws Exception {
        return (IPortalUrlFactory) portletCtx.getAttribute("UrlService");
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        // Request
        final PortletRequest request = portalControllerContext.getRequest();
        // Response
        final RenderResponse response = (RenderResponse) portalControllerContext.getResponse();


        final Map<String, List<String>> selectors = new HashMap<String, List<String>>();
        // selectors.put("selectorChanged", Arrays.asList(Constants.PORTLET_VALUE_ACTIVATE));

        final PortletURL cleanURL = response.createRenderURL();
        cleanURL.setParameter("selectors", PageSelectors.encodeProperties(selectors));

        if( request.getParameter("selectors")!= null) {
            cleanURL.setParameter("lastSelectors", request.getParameter("selectors"));
        }


        request.setAttribute(CLEAN_URL, cleanURL.toString());
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
        // Request
        final PortletRequest request = portalControllerContext.getRequest();

        // Current window
        final PortalWindow window = WindowFactory.getWindow(request);

        String nuxeoPath = window.getProperty("osivia.nuxeoPath");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        request.setAttribute("nuxeoPath", nuxeoPath);
    }


    /**
     * {@inheritDoc}
     */
    public void processAdminAction(PortalControllerContext portalControllerContext) throws PortletException {
        // Request
        final PortletRequest request = portalControllerContext.getRequest();

        // Current window
        final PortalWindow window = WindowFactory.getWindow(request);

        final String nuxeoPath = request.getParameter("nuxeoPath");
        if (StringUtils.isNotEmpty(nuxeoPath)) {
            window.setProperty("osivia.nuxeoPath", nuxeoPath);
        } else {
            window.setProperty("osivia.nuxeoPath", null);
        }
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isDisplayedInAdmin() {
        return true;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getViewJSPName() {
        return "clean-selectors";
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public String getAdminJSPName() {
        return "clean-selectors";
    }

}