/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.customizer.attributes;

import fr.toutatice.cartoun.customizer.attributes.SocialMetadataAttributesBundle;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.portlet.PortletException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.core.theme.PageRendition;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.html.DOM4JUtils;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

/*
 * Exception performing whole class analysis ignored.
 */
public class SocialMetadataAttributesBundle
implements IAttributesBundle {
    private static final String SOCIAL_METADATA_NAME = "acrennes.sites.cartoun.socialMetadata.name";
    private static final String OSIVIA_CONTENT_PATH = "osivia.cms.contentPath";
    private static final String META_TAG = "meta";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PROPERTY = "property";
    private static final String ATTRIBUTE_CONTENT = "content";
    private static final String TWITTER_CARD_TYPE = "summary_large_image";
    private static final String TWITTER_SITE = System.getProperty("acrennes.sites.cartoun.twitter.site");
    private static final String FB_APP_ID = System.getProperty("acrennes.sites.cartoun.facebook.app.id");
    private static final String VIGNETTE_DEFAUT_WEBID = "vignette-par-defaut";
    private final IPortalUrlFactory urlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    private final Set<String> names = new TreeSet();

    public static SocialMetadataAttributesBundle getInstance() {
        return SocialMetadataAttributesBundleHolder.access$100();
    }

    private SocialMetadataAttributesBundle() {
        this.names.add("acrennes.sites.cartoun.socialMetadata.name");
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        ArrayList metadataList = new ArrayList();
        Page page = renderPageCommand.getPage();
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        String contentPath = this.computePath(controllerContext, page, "osivia.cms.contentPath");
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        try {
            NuxeoDocumentContext documentContext;
            if (contentPath != null && (documentContext = NuxeoController.getDocumentContext((PortalControllerContext)portalControllerContext, (String)contentPath)).getType() != null && StringUtils.equals((String)documentContext.getType().getName(), (String)"UsageNum")) {
                Document activite = documentContext.getDoc();
                String webId = activite.getProperties().getString("ttc:webid");
                boolean shareable = BooleanUtils.isTrue((Boolean)activite.getProperties().getBoolean("unum:shareable"));
                if (StringUtils.isNotBlank((String)webId) && shareable) {
                    String webPath = NuxeoController.webIdToCmsPath((String)webId);
                    String canonicalURL = this.urlFactory.getPermaLink(portalControllerContext, null, null, webPath, "share");
                    String vignetteLink = this.buildUsageNUmVignetteUrl(portalControllerContext, activite);
                    String vignetteUrl = this.urlFactory.getBasePortalUrl(portalControllerContext) + vignetteLink;
                    this.generateMetaTwitter(metadataList, activite, vignetteUrl, portalControllerContext);
                    this.generateMetaOpenGraph(metadataList, activite, canonicalURL, vignetteUrl, portalControllerContext);
                }
            }
        }
        catch (PortalException e) {
            throw new ControllerException((Throwable)e);
        }
        catch (PortletException e) {
            throw new ControllerException((Throwable)e);
        }
        attributes.put("acrennes.sites.cartoun.socialMetadata.name", metadataList);
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }

    public String buildUsageNUmVignetteUrl(PortalControllerContext portalControllerContext, Document activite) throws PortletException {
        String urlVignette = "";
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getPortletCtx());
        PropertyMap map = activite.getProperties().getMap("ttc:vignette");
        urlVignette = map != null ? nuxeoController.createFileLink(activite, "ttc:vignette") : this.getPictureLinkByWebId(nuxeoController, "vignette-par-defaut");
        return urlVignette;
    }

    public String buildStageVignetteUrl(PortalControllerContext portalControllerContext, Document portalPage) throws PortletException {
        String vignetteLink = "";
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext.getPortletCtx());
        nuxeoController.setServletRequest(((ControllerContext)portalControllerContext.getControllerCtx()).getServerInvocation().getServerContext().getClientRequest());
        PropertyMap pageVignette = portalPage.getProperties().getMap("ttcn:picture");
        vignetteLink = pageVignette != null ? nuxeoController.createFileLink(portalPage, "ttcn:picture") : this.getPictureLinkByWebId(nuxeoController, "vignette-greta");
        return vignetteLink;
    }

    private String getPictureLinkByWebId(NuxeoController nuxeoController, String webId) throws PortletException {
        String vignetteCmsPath;
        String vignetteGeneriquePath = NuxeoController.webIdToFetchPath((String)webId);
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        try {
            vignetteCmsPath = cmsService.adaptWebPathToCms(nuxeoController.getCMSCtx(), vignetteGeneriquePath);
        }
        catch (Exception e) {
            return "";
        }
        return nuxeoController.createPictureLink(vignetteCmsPath, "Original");
    }

    private void generateMetaTwitter(List<String> metadataList, Document activite, String vignetteUrl, PortalControllerContext portalControllerContext) throws ControllerException {
        PropertyMap properties = activite.getProperties();
        metadataList.add(this.buildMetaTagWithName("twitter:card", "summary_large_image"));
        metadataList.add(this.buildMetaTagWithName("twitter:site", TWITTER_SITE));
        if (StringUtils.isNotBlank((String)properties.getString("dc:title"))) {
            metadataList.add(this.buildMetaTagWithName("twitter:title", properties.getString("dc:title")));
        }
        if (StringUtils.isNotBlank((String)properties.getString("unum:resume"))) {
            metadataList.add(this.buildMetaTagWithName("twitter:description", properties.getString("unum:resume")));
        }
        metadataList.add(this.buildMetaTagWithName("twitter:image", vignetteUrl));
    }

    private void generateMetaOpenGraph(List<String> metadataList, Document stage, String canonicalUrl, String vignetteUrl, PortalControllerContext portalControllerContext) throws ControllerException {
        PropertyMap properties = stage.getProperties();
        metadataList.add(this.buildMetaTagWithProperty("fb:app_id", FB_APP_ID));
        if (StringUtils.isNotBlank((String)properties.getString("dc:title"))) {
            metadataList.add(this.buildMetaTagWithProperty("og:title", properties.getString("dc:title")));
        }
        metadataList.add(this.buildMetaTagWithProperty("og:image", vignetteUrl));
        metadataList.add(this.buildMetaTagWithProperty("og:type", "article"));
        metadataList.add(this.buildMetaTagWithProperty("og:url", canonicalUrl));
        if (StringUtils.isNotBlank((String)properties.getString("unum:resume"))) {
            metadataList.add(this.buildMetaTagWithProperty("og:description", properties.getString("unum:resume")));
        }
        if (StringUtils.isNotBlank((String)properties.getString("dc:creator"))) {
            metadataList.add(this.buildMetaTagWithProperty("article:author", properties.getString("dc:creator")));
        }
    }

    private String buildMetaTagWithName(String name, String content) {
        Element metaTag = DOM4JUtils.generateElement((String)"meta", null, null);
        DOM4JUtils.addAttribute((Element)metaTag, (String)"name", (String)name);
        DOM4JUtils.addAttribute((Element)metaTag, (String)"content", (String)content);
        return DOM4JUtils.write((Element)metaTag);
    }

    private String buildMetaTagWithProperty(String property, String content) {
        Element metaTag = DOM4JUtils.generateElement((String)"meta", null, null);
        DOM4JUtils.addAttribute((Element)metaTag, (String)"property", (String)property);
        DOM4JUtils.addAttribute((Element)metaTag, (String)"content", (String)content);
        return DOM4JUtils.write((Element)metaTag);
    }

    private String computePath(ControllerContext controllerContext, Page page, String pathType) {
        NavigationalStateContext navigationalStateContext = (NavigationalStateContext)controllerContext.getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
        PageNavigationalState pageState = navigationalStateContext.getPageNavigationalState(page.getId().toString());
        String[] sPath = null;
        if (pageState != null) {
            sPath = pageState.getParameter(new QName("", "osivia.cms.contentPath"));
        }
        if (ArrayUtils.isNotEmpty(sPath)) {
            return sPath[0];
        }
        return null;
    }
}

