package fr.toutatice.cartoun.plugin.detailactivite;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.portlet.PortletException;

import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.player.IPlayerModule;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;

public class DetailActivitePlugin extends AbstractPluginPortlet {

    /** Plugin name. */
    private static final String PLUGIN_NAME = "detail.activite.plugin";

	/** Bundle factory. */
	protected IBundleFactory bundleFactory;

	@Override
	public void init() throws PortletException {
		super.init();

		// Bundle factory
        final IInternationalizationService internationalizationService = Locator.findMBean(IInternationalizationService.class,
                IInternationalizationService.MBEAN_NAME);
        bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
	}

	@Override
	protected String getPluginName() {
        return PLUGIN_NAME;
	}

	@Override
	protected void customizeCMSProperties(String customizationID,
			CustomizationContext context) {
        final Map<String, DocumentType> docTypes = getDocTypes(context);

        final ArrayList<String> portalFormSubTypes = new ArrayList<String>(0);
        docTypes.put(DetailActivitePlayer.DOCTYPE_UsageNUm, new DocumentType(DetailActivitePlayer.DOCTYPE_UsageNUm, false, false, false, false, false, true,
                portalFormSubTypes, null, null, false, false, false));

        final List<IPlayerModule> modules = getPlayers(context);
        modules.add(0, new DetailActivitePlayer(getPortletContext()));
	}

}
