package fr.toutatice.cartoun.portlet.detailactivite.command;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;

public class CtrlPermissionCommand implements INuxeoCommand{
	
	protected static final Log logger = LogFactory.getLog(CtrlPermissionCommand.class);	
	private static final String OP_NUXEO_LIVEDOCUMENT_FETCH = "Document.FetchLiveDocument";
	
	String permissions;
	Document doc;
	String operation;
	
	public CtrlPermissionCommand(String permissions, Document doc, String operation) {
		super();
		this.permissions = permissions;
		this.doc = doc;
		this.operation = operation;
	}
	
	public Object execute(Session nuxeoSession) throws Exception {
		
		Object response = null;
		try{
			OperationRequest reqNuxeo = nuxeoSession.newRequest(OP_NUXEO_LIVEDOCUMENT_FETCH);
			reqNuxeo.setHeader(Constants.HEADER_NX_SCHEMAS, "*");
			reqNuxeo.set("value", this.doc);
			reqNuxeo.set("permission", this.permissions);
			if(StringUtils.isNotBlank(this.operation)){
				reqNuxeo.set("operation", this.operation);
			}
			response = reqNuxeo.execute();
			//logger.info(" execute nuxeo request, OK ! ");
			
		}catch(Exception e){
			logger.warn(" *** "+e.getMessage());				
		}
		return response;
	}
	


	public String getId() {	
		return "CtrlPermissionCommand";
	}

}
