package fr.toutatice.cartoun.portlet.detailactivite.command;

import java.io.IOException;
import java.io.InputStreamReader;




import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParser;
import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.StringBlob;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;

public class PermalinkCommand implements INuxeoCommand{
	private String codec;
	private Document input;
	private static final String OP_NUXEO = "Document.permalink";
	
	public PermalinkCommand(String codec, Document input){
		this.codec = codec;
		this.input = input;
	}

	public Object execute(Session nuxeoSession) throws Exception {
				
		OperationRequest reqNuxeo = nuxeoSession.newRequest(OP_NUXEO);
		reqNuxeo.setHeader(Constants.HEADER_NX_SCHEMAS, "*");
		reqNuxeo.set("codec", this.codec);
		reqNuxeo.setInput(input);
		
		Blob url = (Blob) reqNuxeo.execute();
		
		return getValue(url);
	}

	public String getId() {
		
		return "PermalinkWithCodec";
	}
	
	private static String getValue(Blob object) throws IOException, JSONParseException {
		String res = "";
		InputStreamReader reader = new InputStreamReader(object.getStream());
		JSONParser jsonParser = new JSONParser();
		JSONObject jsonObject = (JSONObject) jsonParser.parse(reader);
		res = (String)jsonObject.get("permalink");
		
		return res;
	}

}
