package fr.toutatice.cartoun.portlet.detailactivite.controller;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.directory.entity.DirectoryPerson;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.springframework.expression.ParseException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

import com.sun.mail.smtp.SMTPTransport;

import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.LinkBean;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ReferentBean;
import fr.toutatice.cartoun.portlet.detailactivite.command.BecomeReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.CtrlPermissionCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.DeleteReferentCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.PermalinkCommand;
import fr.toutatice.cartoun.portlet.detailactivite.command.RetrieveActiviteByIdCommand;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;


@Controller
@RequestMapping("VIEW")
public class DetailActiviteController extends CMSPortlet implements PortletContextAware, PortletConfigAware{

	protected static final Log logger = LogFactory.getLog(DetailActiviteController.class);

    // timeout du rafraîchissemnet ElasticSearch en milliseconde, valeur par défaut: 2s
    private static final Long ES_REFRESH_TIMEOUT = NumberUtils.toLong(System.getProperty("toutatice.cartoun.es.refresh.timeout"), 2000);

    private static final String PIA_CMS_URI = "osivia.cms.uri";
    private static final String ERROR_PAGE = "error";
    private static final String ACTIVITE_PAGE = "detailActivite";

	private PortletContext portletContext;
	private PortletConfig portletConfig;


	@Override
	public void init(PortletConfig config) throws PortletException
	{
		super.init(config);
	}

	@Override
	public void destroy() {

		super.destroy();
	}


	@PostConstruct
	public void initNuxeoService() throws Exception {
		super.init();
		if ((portletContext != null)
				&& (portletContext.getAttribute("nuxeoService") == null)) {
			logger.info(" Start  nuxeo service ...");
			this.init(portletConfig);
			logger.info("Nuxeo service  started! ");
		}

	}


	@PreDestroy
	public void cleanUpNuxeoService() throws Exception {
		if ((portletContext != null)
				&& (portletContext.getAttribute("nuxeoService") == null)) {
			logger.info(" Stop  nuxeo service ...");
			this.destroy();
			logger.info("Nuxeo service  stopped! ");
		}
	}



	@RequestMapping
	public String showActivite(RenderRequest request, RenderResponse response, PortletSession session) throws Exception {
		String returnPage = ERROR_PAGE;


		ActiviteBean act = null;
		final PortalWindow window = WindowFactory.getWindow(request);
        final String pathAct = window.getProperty(PIA_CMS_URI);

		window.setProperty("osivia.permalinkportlet", "1");
        if ((pathAct != null) && !"".equals(pathAct)) {
            final NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);
            final CMSPublicationInfos publicationInfos = NuxeoController.getCMSService().getPublicationInfos(nuxeoController.getCMSCtx(), pathAct);

			final boolean beingModified = publicationInfos.isBeingModified();
			request.setAttribute("beingModified",beingModified);

			final String level = request.getParameter("levelSelected");
			Date savedDate=new Date(0);
            Document doc = null;
			if(StringUtils.isBlank(level)){
                final NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
                final Document liveDoc = (Document) nuxeoController.executeNuxeoCommand(new CtrlPermissionCommand("aspire", documentContext.getDoc(), null));
				final Boolean canBecomeReferent = (liveDoc!=null);
				request.setAttribute("canBecomeReferent", canBecomeReferent);
                Thread.sleep(ES_REFRESH_TIMEOUT);
                doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
			}else{
				final DirectoryPerson person = (DirectoryPerson) request.getAttribute(Constants.ATTR_LOGGED_PERSON);
                nuxeoController.setDisplayLiveVersion("1");
                NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
                doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
                savedDate = doc.getProperties().getDate("dc:modified");
                nuxeoController.executeNuxeoCommand(new BecomeReferentCommand(person.getUid(), level, doc));
                // on attends la réindexation nuxeo
                final long time = System.currentTimeMillis();
                while (System.currentTimeMillis() < (time + ES_REFRESH_TIMEOUT)) {
                    // toute les 100ms dans la limite du timeout
                    Thread.sleep(100);
                    documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
                    doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
                    if (doc.getProperties().getDate("dc:modified").after(savedDate)) {
                        // si le document a bien été réindexé, on poursuit
                        break;
                    }
                }
			}


            act = commonInitialization(request, response, doc, nuxeoController);
		}

		if(act != null){
			returnPage = ACTIVITE_PAGE;
		}
		return returnPage;
	}


	@RequestMapping(params = "action=refreshAfterDelete")
	public String refreshAfterDeleteReferents(RenderRequest request, RenderResponse response, PortletSession session) throws Exception{
		String returnPage = ERROR_PAGE;

		ActiviteBean act = null;
        final PortalWindow window = WindowFactory.getWindow(request);
        final String pathAct = window.getProperty(PIA_CMS_URI);
        final NuxeoController nuxeoController = new NuxeoController(request, response, portletContext);

        nuxeoController.setDisplayLiveVersion("1");
        NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
        Document doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);
        final Date savedDate = doc.getProperties().getDate("dc:modified");
        doc = (Document) nuxeoController.executeNuxeoCommand(new DeleteReferentCommand(request.getParameter("selectedUid"), doc));
		final Document liveDoc = 	(Document)nuxeoController.executeNuxeoCommand(new CtrlPermissionCommand("aspire", doc, null));
		final Boolean canBecomeReferent = liveDoc!=null;
		request.setAttribute("canBecomeReferent", canBecomeReferent);

        // on attends la réindexation nuxeo
        final long time = System.currentTimeMillis();
        while (System.currentTimeMillis() < (time + ES_REFRESH_TIMEOUT)) {
            // toute les 100ms dans la limite du timeout
            Thread.sleep(100);
            documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), pathAct);
            doc = ((Documents) nuxeoController.executeNuxeoCommand(new RetrieveActiviteByIdCommand(documentContext.getDoc().getId()))).get(0);

            if (doc.getProperties().getDate("dc:modified").after(savedDate)) {
                // si le document a bien été réindexé, on poursuit
                break;
            }
        }
		act = commonInitialization(request, response, doc, nuxeoController);
		if(act != null){
			returnPage = ACTIVITE_PAGE;
		}
		return returnPage;

	}

	@ActionMapping(params="action=becomeReferent")
	public void levelSelected(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session)
			throws ParseException {

			final String level = refForm.getLevelSelected();
			response.setRenderParameter("levelSelected", level);
			response.setRenderParameter("action", "default");

	}


	@ActionMapping(params="action=deleteReferent")
	public void deleteReferent(@RequestParam String uid, ActionResponse response, ActionRequest request, PortletSession session)
			throws ParseException {

		response.setRenderParameter("selectedUid", uid);
		response.setRenderParameter("action", "refreshAfterDelete");
	}

	@ResourceMapping
	public void serveResource(ResourceRequest resourceRequest,ResourceResponse resourceResponse, PortletSession session) throws PortletException,
			IOException {

		super.serveResource(resourceRequest, resourceResponse);

	}


//	#3858 ENVOI DE MAIL
	@ActionMapping(params="action=toContact")
	public void sendMail(@ModelAttribute ReferentBean refForm, BindingResult result, ActionResponse response, ActionRequest request, PortletSession session){


			final DirectoryPerson person = (DirectoryPerson) request.getAttribute(Constants.ATTR_LOGGED_PERSON);

			// Récupération des propriétés systemes (configurés dans le portal.properties).
			final Properties props = System.getProperties();

			final Session mailSession = Session.getInstance(props, null);

			// Nouveau message
			final MimeMessage msg = new MimeMessage(mailSession);

			// -- Set the FROM and TO fields --
			try {
				msg.setFrom(new InternetAddress(person.getEmail()));

				msg.setSubject(refForm.getSubject(), "UTF-8");

				final String mailDestinataire = refForm.getEmail();

				msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(mailDestinataire, false));

				final Multipart mp = new MimeMultipart();
				final MimeBodyPart txtPart = new MimeBodyPart();
				txtPart.setText(refForm.getBodyMail(), "UTF-8");
				mp.addBodyPart(txtPart);

				msg.setContent(mp);

				msg.setSentDate(new Date());

				final SMTPTransport t = (SMTPTransport) mailSession.getTransport();

				t.connect();
				t.sendMessage(msg, msg.getAllRecipients());
				t.close();
			} catch (final AddressException e) {
				logger.error("erreur envoi mail", e);
			} catch (final MessagingException e) {
				logger.error("erreur envoi mail", e);
			}

		}



	@Override
    public void setPortletConfig(PortletConfig portletConfig) {
		this.portletConfig = portletConfig;
	}

	@Override
    public void setPortletContext(PortletContext portletContext) {
		this.portletContext = portletContext;
	}

	private ActiviteBean commonInitialization(RenderRequest request, RenderResponse response, Document doc,
			NuxeoController nuxeoCtl) throws Exception, CMSException, UnsupportedEncodingException {


        final Principal principal = request.getUserPrincipal();
        final ActiviteBean act = convertNuxeoDocToActiviteBean(doc, nuxeoCtl, principal.getName());

		//permalien viaeduc
        if (StringUtils.isNotBlank(doc.getString("unum:groupeViaeduc"))) {
            final String link = (String) nuxeoCtl.executeNuxeoCommand(new PermalinkCommand("viaeduclink", doc));
            act.setViaeduc(link);
        }

		//stat
        final String stats = System.getProperty("stats.enable");
        if (StringUtils.equalsIgnoreCase(stats, "true")) {
			final String idDun = doc.getPath().substring(0, doc.getPath().lastIndexOf('/'));
            final NuxeoDocumentContext documentContext = NuxeoController.getDocumentContext(request, response, getPortletContext(), idDun);
            final Document dun = documentContext.getDoc();
			String dunName = dun.getString("dun:subtitle");
			if(dunName == null){
				dunName = dun.getTitle();
			}
			dunName = dunName.trim();
			act.setDun(dunName);
		}

		// Comments
//		List<CommentDTO> comments = (List<CommentDTO>) nuxeoCtl.executeNuxeoCommand(new GetCommentsCommand(liveDoc));
//		act.setComments(comments);

		request.setAttribute("activity",act);

		final VocabularyEntry vocNivRef = VocabularyHelper.getVocabularyEntry(nuxeoCtl, "unu_niveauReferent");
		final Collection<VocabularyEntry> childrenValue = vocNivRef.getChildren().values();

		request.setAttribute("voc",childrenValue);
		request.setAttribute("refForm", new ReferentBean());

		nuxeoCtl.setCurrentDoc(doc);
		nuxeoCtl.insertContentMenuBarItems();

		return act;
	}


	private ActiviteBean convertNuxeoDocToActiviteBean(Document doc,NuxeoController nxController,String uidCurrent) throws Exception {
		final ActiviteBean res = new ActiviteBean();

		res.setId(doc.getId());
		String label = VocabularyHelper.getVocabularyLabel(nxController,
				"unu_niveau", doc.getString("unum:niv"));
		res.setLevel(label);
		label = VocabularyHelper.getVocabularyLabel(nxController,
				"unu_duree", doc.getString("unum:duree"));
		res.setDuration(label);
		label = VocabularyHelper.getVocabularyLabel(nxController,
				"unu_transferabilite", doc.getString("acrp:transferabilite"));
		res.setTransferability(label);
		res.setSummary(doc.getProperties().getString("unum:resume"));
		res.setScenario(doc.getProperties().getString("unum:scenario"));
		res.setTrap(doc.getProperties().getString("unum:piege"));
		res.setAnalysis(doc.getProperties().getString("unum:analyse"));
		res.setTitle(doc.getTitle());
		res.setLastContributor(doc.getProperties().getString("dc:lastContributor"));
        final String uidAuthor = doc.getProperties().getString("dc:creator");
        res.setAuthor(uidAuthor);

        res.setExperitheque(doc.getProperties().getBoolean("unum:experitheque"));
		res.setUrlExpe(doc.getProperties().getString("unum:urlExpe"));

        PropertyList lst = doc.getProperties().getList("acrp:disciplines");
		final String[] vocabulaires = {"disciplines_parent","disciplines"};
		res.setLstDisciplines(protertyStringToListString(vocabulaires, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("acrp:niveauxEducatifs");
		final String[] vocabulaires1 = {"niveauxEducatifs","niveauxEducatifs","niveauxEducatifs"};
		res.setLstPublics(protertyStringToListString(vocabulaires1, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("acrp:naturesPedagogiques");
		res.setLstPedagogicals(protertyStringToListString(new String[]{"unu_naturepeda"}, lst,nxController));
		final List<String> lstString = new ArrayList<String>();
		for (final Object ppt : lst.list()) {
			if (ppt.equals("autres")) {
				final StringBuilder sb = new StringBuilder();
				sb.append("Autres");
				if (doc.getProperties().getString("unum:natPedaAutre") != null) {
					sb.append(" : ");
					sb.append(doc.getProperties().getString("unum:natPedaAutre"));
				}
				;
				lstString.add(sb.toString());
			} else {
				final String labelbis = VocabularyHelper.getVocabularyLabel(nxController, "unu_naturepeda", (String) ppt);
				lstString.add(labelbis);
			}
		}

		lst = (PropertyList) doc.getProperties().get("unum:parcours");
		res.setLstParcours(protertyStringToListString(new String[]{"carto_parcours"}, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("unum:axe");
		res.setLstAxes(protertyStringToListString(new String[]{"carto_axes"}, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("acrp:pratique");
		res.setLstPractices(protertyStringToListString(new String[]{"unu_pratiques"}, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("acrp:cadresUtilisations");
		res.setLstCadres(protertyStringToListString(new String[]{"unu_modalite"}, lst,nxController));


		lst = (PropertyList) doc.getProperties().get("acrp:lieu");
		res.setLstPlaces(protertyStringToListString(new String[]{"unu_lieu"}, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("acrp:outils");
		res.setLstTools(protertyStringToListString(new String[]{"unu_outils","unu_outils_child1"}, lst,nxController));


		lst = (PropertyList) doc.getProperties().get("acrp:competences");
		res.setLstCompetence(protertyStringToListString(null, lst,nxController));
		lst = (PropertyList) doc.getProperties().get("unum:logicielLocal");
		res.setLstSoftware(protertyStringToListString(null, lst,nxController));

		lst = (PropertyList) doc.getProperties().get("unum:logicielInternet");
		final List<LinkBean> lstESoftware = new ArrayList<LinkBean>();
		for (int i=0;i<lst.size();i++) {
			lstESoftware.add(new LinkBean(lst.getMap(i).getString("name"), lst.getMap(i).getString("url")));
		}
		res.setLstESoftware(lstESoftware);

        lst = (PropertyList) doc.getProperties().get("unum:referents");
		List<ReferentBean> lstRefLevel1=null;
		List<ReferentBean> lstRefLevel2=null;

        for (final Object referentsO : lst.list()) {
            final PropertyMap referentMap = (PropertyMap) referentsO;

            if ((referentMap.get("owner") != null) && referentMap.getBoolean("owner")) {
                res.setOwner(referentMap.getString("uid"));
            }

            final Integer iLevel = new Integer(referentMap.getString("niveau"));
            switch (iLevel) {
            case 1:
                if(lstRefLevel1==null){
                    lstRefLevel1 = new ArrayList<ReferentBean>();
                    res.setLabelReferent1(VocabularyHelper.getVocabularyLabel(nxController, "unu_niveauReferent", "1"));
                }
                    lstRefLevel1.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                break;
            case 2:
                if(lstRefLevel2==null){
                    lstRefLevel2 = new ArrayList<ReferentBean>();
                    res.setLabelReferent2(VocabularyHelper.getVocabularyLabel(nxController, "unu_niveauReferent", "2"));
                }
                    lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                break;
            case 3:
                // fusion des listes ref2 et ref3 qui ne doivent plus être différentiées sur le portail
                if(lstRefLevel2==null){
                    lstRefLevel2 = new ArrayList<ReferentBean>();
                    res.setLabelReferent3(VocabularyHelper.getVocabularyLabel(nxController, "unu_niveauReferent", "3"));
                }
                lstRefLevel2.add(new ReferentBean(referentMap, uidCurrent, uidAuthor));
                break;
            }
        }

		res.setLstReferent1(lstRefLevel1);
		res.setLstReferent2(lstRefLevel2);

		final PropertyMap map = doc.getProperties().getMap("ttc:vignette");
        if (map != null) {
            final String urlVignette = nxController.createFileLink(doc, "ttc:vignette");
            res.setUrlVignette("<img class=\"kartoun-titre-img-float\" src=\"" + urlVignette + "\" />");
		}else{
            res.setUrlVignette("<img class=\"kartoun-titre-img-float\" src=\"/cartoun-detailactivite/img/kartoun-vignette.png\"/>");
		}
		if(doc.getDate("dc:issued")!=null){
			res.setDatePublication(doc.getDate("dc:issued"));
		}else{
			res.setDatePublication(doc.getDate("dc:modified"));
		}
		// pour les stats
		if(doc.getPath().endsWith(".proxy")){
			res.setDraft(false);
		}else{
			res.setDraft(true);
		}

		//pjs
		final PropertyList files = doc.getProperties().getList("files:files");
        if ((null != files) && !files.isEmpty()) {
			int idx = 0;
			final HashMap<String, String> mapPj = new HashMap<String, String>(files.size());
			while (idx < files.size()) {
				mapPj.put(files.getMap(idx).getString("filename"), nxController.createAttachedFileLink(doc.getPath(), String.valueOf(idx)));
				idx++;
			}
			res.setPj(mapPj);
		}

		return res;
	}

	private List<String> protertyStringToListString(String[] vocabularyName,
			PropertyList lst,NuxeoController nxController) throws Exception {
		final List<String> lstString = new ArrayList<String>();


		for (int i = 0; i < lst.size(); i++) {
			final String value = lst.getString(i);
			if(vocabularyName!=null){
				final String[] split = value.split("/");
				final StringBuilder sb = new StringBuilder();
				for (int j=0;j<split.length;j++) {
					sb.append(VocabularyHelper.getVocabularyLabel(nxController,
						vocabularyName[j], split[j].trim()));
					if(j < (split.length-1)){
						sb.append(" / ");
					}
				}
			lstString.add(sb.toString());
			}else{
				lstString.add(value);
			}
		}

		return lstString;
	}

}
