package fr.toutatice.cartoun.portlet.detailactivite.bean;

import java.util.ArrayList;
import java.util.List;

import org.nuxeo.ecm.automation.client.model.PropertyMap;


public class ReferentBean {

	String level;
	String levelLabel;
	String identite;
	String subject;
	String email;
	String uid;
	String levelSelected;
	Boolean canDelete;
	Boolean isAuthor;
	String bodyMail;

    private List<LinkBean> socialnetworks;

	public ReferentBean(){
		super();
	}

    public ReferentBean(String level, String identite, String email, String uid, Boolean canDelete) {
		super();
		this.level = level;
		this.identite = identite;
		this.email = email;
		this.uid = uid;
	}

    public ReferentBean(PropertyMap ppt, String uidCurrent, String idAuthor) {
		super();
		this.level = ppt.getString("niveau");
        this.uid = ppt.getString("uid");
        this.identite = ppt.getString("displayName");
        this.email = ppt.getString("email");
		if(this.uid.equals(idAuthor)){
            this.canDelete = false;
			this.identite = this.identite.concat(" (Auteur)");
        } else {
            this.canDelete = this.uid.equals(uidCurrent);
		}
	}

	public String getLevel() {
		return level;
	}
	public void setLevel(String level) {
		this.level = level;
	}
	public String getIdentite() {
		return identite;
	}
	public void setIdentite(String identite) {
		this.identite = identite;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getUid() {
		return uid;
	}
	public void setUid(String uid) {
		this.uid = uid;
	}
	public String getLevelLabel() {
		return levelLabel;
	}
	public void setLevelLabel(String levelLabel) {
		this.levelLabel = levelLabel;
	}

	public String getLevelSelected() {
		return levelSelected;
	}

	public void setLevelSelected(String levelSelected) {
		this.levelSelected = levelSelected;
	}

	public Boolean getCanDelete() {
		return canDelete;
	}

	public void setCanDelete(Boolean canDelete) {
		this.canDelete = canDelete;
	}

	public Boolean getIsAuthor() {
		return isAuthor;
	}

	public void setIsAuthor(Boolean isAuthor) {
		this.isAuthor = isAuthor;
	}

	public String getBodyMail() {
		return bodyMail;
	}

	public void setBodyMail(String bodyMail) {
		this.bodyMail = bodyMail;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

    /**
     * Getter for socialnetworks.
     *
     * @return the socialnetworks
     */
    public List<LinkBean> getSocialnetworks() {
        if (socialnetworks == null) {
            socialnetworks = new ArrayList<LinkBean>();
        }
        return socialnetworks;
    }

    /**
     * Setter for socialnetworks.
     *
     * @param socialnetworks the socialnetworks to set
     */
    public void setSocialnetworks(List<LinkBean> socialnetworks) {
        this.socialnetworks = socialnetworks;
    }


}
