package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import java.io.IOException;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;

import javax.portlet.PortletContext;

import org.apache.commons.io.IOUtils;
import org.osivia.portal.api.internationalization.Bundle;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;

import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;


public class ActiviteFooter extends PdfPageEventHelper {

    private static final String CC_IMG_URL = "/img/CreativeCommons.png";

    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd MMMMM yyyy");

    private Font defaultFont;

    private Font boldFont;

    private PortletContext portletContext;

    private ActiviteBean activite;

    Bundle bundle;

    public ActiviteFooter(Font defaultFont, Font boldFont, PortletContext portletContext, ActiviteBean activite, Bundle bundle) {
        this.defaultFont = defaultFont;
        this.boldFont = boldFont;
        this.portletContext = portletContext;
        this.activite = activite;
        this.bundle = bundle;
    }

    @Override
    public void onEndPage(PdfWriter writer, Document document) {
        try {

            Phrase auteur = new Phrase(bundle.getString("label.author"), boldFont);
            auteur.add(new Chunk(" : "));
            auteur.add(new Chunk(activite.getAuthor(), defaultFont));
            ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_LEFT, auteur, document.left() + 70, document.bottom() - 23, 0);

            if (activite.getDateModification() != null) {
                Phrase date = new Phrase(bundle.getString("date.derniere.modification"), boldFont);
                date.add(new Chunk(" : "));
                date.add(new Chunk(sdf.format(activite.getDatePublication()), defaultFont));
                ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_LEFT, date, document.left() + 70, document.bottom() - 35, 0);
            } else if (activite.getDatePublication() != null) {
                Phrase date = new Phrase(bundle.getString("date.derniere.publication"), boldFont);
                date.add(new Chunk(" : "));
                date.add(new Chunk(sdf.format(activite.getDatePublication()), defaultFont));
                ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_LEFT, date, document.left() + 70, document.bottom() - 35, 0);
            }

            Image ccImage = Image.getInstance(IOUtils.toByteArray(portletContext.getResourceAsStream(CC_IMG_URL)));
            ccImage.setAbsolutePosition(document.left() - (document.leftMargin() / 2), document.bottom() - (document.bottomMargin() - 10));
            document.add(ccImage);

            Phrase url = new Phrase(20, "http://creativecommons.fr/licences/", defaultFont);
            ColumnText.showTextAligned(writer.getDirectContent(), Element.ALIGN_LEFT, url, document.left() + 70, document.bottom() - 47, 0);

        } catch (MalformedURLException e) {
        } catch (IOException e) {
        } catch (DocumentException e) {
        }
    }

}
