package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.apply.ChunkCssApplier;
import com.itextpdf.tool.xml.css.apply.DivCssApplier;
import com.itextpdf.tool.xml.css.apply.HtmlCellCssApplier;
import com.itextpdf.tool.xml.css.apply.LineSeparatorCssApplier;
import com.itextpdf.tool.xml.css.apply.ListStyleTypeCssApplier;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.NoNewLineParagraphCssApplier;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.css.apply.ParagraphCssApplier;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;


/**
 * applique le CSS suivant le type d'objet
 * permet de forcer l'utilisation de OsiviaImageCssApplier pour les images
 *
 * @author dorian
 */
public class OsiviaCssapplier implements CssAppliers {

    protected ChunkCssApplier chunk;
    protected ParagraphCssApplier paragraph;
    private NoNewLineParagraphCssApplier nonewlineparagraph;
    private HtmlCellCssApplier htmlcell;
    private ListStyleTypeCssApplier list;
    private LineSeparatorCssApplier lineseparator;
    private OsiviaImageCssApplier image;
    private DivCssApplier div;

    public OsiviaCssapplier() {
        chunk = new ChunkCssApplier(null);
        paragraph = new ParagraphCssApplier(this);
        nonewlineparagraph = new NoNewLineParagraphCssApplier();
        htmlcell = new HtmlCellCssApplier();
        list = new ListStyleTypeCssApplier();
        lineseparator = new LineSeparatorCssApplier();
        image = new OsiviaImageCssApplier();
        div = new DivCssApplier();
    }

    @Override
    public Element apply(Element e, final Tag t, final MarginMemory mm, final PageSizeContainable psc, final HtmlPipelineContext ctx) {
        // warning, mapping is done by instance of, make sure to add things in the right order when adding more.
        if (e instanceof Chunk) { // covers TabbedChunk & Chunk
            e = chunk.apply((Chunk) e, t);
        } else if (e instanceof Paragraph) {
            e = paragraph.apply((Paragraph) e, t, mm);
        } else if (e instanceof NoNewLineParagraph) {
            e = nonewlineparagraph.apply((NoNewLineParagraph) e, t, mm);
        } else if (e instanceof HtmlCell) {
            e = htmlcell.apply((HtmlCell) e, t, mm, psc);
        } else if (e instanceof List) {
            e = list.apply((List) e, t, ctx);
        } else if (e instanceof LineSeparator) {
            e = lineseparator.apply((LineSeparator) e, t, psc);
        } else if (e instanceof Image) {
            e = image.apply((Image) e, t);
        } else if (e instanceof PdfDiv) {
            e = div.apply((PdfDiv) e, t, mm, psc, ctx);
        }
        return e;
    }

    @Override
    public Element apply(final Element e, final Tag t, final HtmlPipelineContext ctx) {
        return this.apply(e, t, ctx, ctx, ctx);
    }

    @Override
    public ChunkCssApplier getChunkCssAplier() {
        return chunk;
    }

    @Override
    public void setChunkCssAplier(final ChunkCssApplier chunkCssAplier) {
        this.chunk = chunkCssAplier;
    }

    @Override
    public CssAppliers clone() {
        OsiviaCssapplier clone = new OsiviaCssapplier();
        clone.chunk = chunk;

        clone.paragraph = paragraph;
        clone.nonewlineparagraph = nonewlineparagraph;
        clone.htmlcell = htmlcell;
        clone.list = list;
        clone.lineseparator = lineseparator;
        clone.image = image;
        clone.div = div;

        return clone;
    }
}
