package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.itextpdf.text.Image;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CSS;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.html.HTML;

/**
 * applique le CSS sur les images PDF
 *
 * gère les images responsive du portail
 *
 * @author dorian
 */
public class OsiviaImageCssApplier {

    /**
     * Applies CSS to an Image. Currently supported:
     * - width
     * - height
     * - borders (color, width)
     * - spacing before and after
     *
     * @param img the image
     * @param tag the tag with the css
     * @return a styled Image
     */
    public Image apply(final Image img, final Tag tag) {
        Map<String, String> cssMap = tag.getCSS();

        String widthValue = cssMap.get(HTML.Attribute.WIDTH);
        if (widthValue == null) {
            widthValue = tag.getAttributes().get(HTML.Attribute.WIDTH);
        }

        String heightValue = cssMap.get(HTML.Attribute.HEIGHT);
        if (heightValue == null) {
            heightValue = tag.getAttributes().get(HTML.Attribute.HEIGHT);
        }

        String classes = tag.getAttributes().get(HTML.Attribute.CLASS);
        if (StringUtils.contains(classes, "img-responsive") || StringUtils.contains(classes, "enlargeable")) {
            img.setScaleToFitLineWhenOverflow(true);
        } else {
            if (widthValue == null) {
                img.setScaleToFitLineWhenOverflow(true);
            } else {
                img.setScaleToFitLineWhenOverflow(false);
            }
        }

        img.setScaleToFitHeight(false);


        CssUtils utils = CssUtils.getInstance();
        float widthInPoints = utils.parsePxInCmMmPcToPt(widthValue);

        float heightInPoints = utils.parsePxInCmMmPcToPt(heightValue);

        if ((widthInPoints > 0) && (heightInPoints > 0)) {
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0) {
            heightInPoints = (img.getHeight() * widthInPoints) / img.getWidth();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0) {
            widthInPoints = (img.getWidth() * heightInPoints) / img.getHeight();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        }

        // apply border CSS
        String borderTopColor = cssMap.get(CSS.Property.BORDER_TOP_COLOR);
        if (borderTopColor != null) {
            img.setBorderColorTop(HtmlUtilities.decodeColor(borderTopColor));
        }

        String borderTopWidth = cssMap.get(CSS.Property.BORDER_TOP_WIDTH);
        if (borderTopWidth != null) {
            img.setBorderWidthTop(utils.parseValueToPt(borderTopWidth, 1f));
        }

        String borderRightColor = cssMap.get(CSS.Property.BORDER_RIGHT_COLOR);
        if (borderRightColor != null) {
            img.setBorderColorRight(HtmlUtilities.decodeColor(borderRightColor));
        }

        String borderRightWidth = cssMap.get(CSS.Property.BORDER_RIGHT_WIDTH);
        if (borderRightWidth != null) {
            img.setBorderWidthRight(utils.parseValueToPt(borderRightWidth, 1f));
        }

        String borderBottomColor = cssMap.get(CSS.Property.BORDER_BOTTOM_COLOR);
        if (borderBottomColor != null) {
            img.setBorderColorBottom(HtmlUtilities.decodeColor(borderBottomColor));
        }

        String borderBottomWidth = cssMap.get(CSS.Property.BORDER_BOTTOM_WIDTH);
        if (borderBottomWidth != null) {
            img.setBorderWidthBottom(utils.parseValueToPt(borderBottomWidth, 1f));
        }

        String borderLeftColor = cssMap.get(CSS.Property.BORDER_LEFT_COLOR);
        if (borderLeftColor != null) {
            img.setBorderColorLeft(HtmlUtilities.decodeColor(borderLeftColor));
        }

        String borderLeftWidth = cssMap.get(CSS.Property.BORDER_LEFT_WIDTH);
        if (borderLeftWidth != null) {
            img.setBorderWidthLeft(utils.parseValueToPt(borderLeftWidth, 1f));
        }
        // end of border CSS

        String before = cssMap.get(CSS.Property.BEFORE);
        if (before != null) {
            img.setSpacingBefore(Float.parseFloat(before));
        }
        String after = cssMap.get(CSS.Property.AFTER);
        if (after != null) {
            img.setSpacingAfter(Float.parseFloat(after));
        }

        img.setWidthPercentage(0);
        return img;
    }
}