package fr.toutatice.cartoun.portlet.detailactivite.util;

import org.apache.commons.lang.StringUtils;

import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;


public class LoggerFormatter {

    private static final String CONSULTATION = "CONSULTATION";

    private static final String PRISE_CONTACT = "PRISE_CONTACT";

    private static final String ANONYME = "ANONYME";

    private static final String NULL = "null";

    private static final String SUN_ = "sun_";

    private static final String PIPE = "|";

    private LoggerFormatter() {
    }

    public static String buildLogEntryConsultation(ActiviteBean activite, String webIdACA) {
        webIdACA = StringUtils.removeStart(webIdACA, SUN_);
        webIdACA = StringUtils.isBlank(webIdACA) ? ANONYME : webIdACA;

        StringBuilder sbLogEntry = new StringBuilder();
        sbLogEntry.append(CONSULTATION);
        sbLogEntry.append(PIPE);
        sbLogEntry.append(activite.getWebId());
        sbLogEntry.append(PIPE);
        sbLogEntry.append(activite.getDomainId());
        sbLogEntry.append(PIPE);
        sbLogEntry.append(webIdACA);
        return sbLogEntry.toString();
    }

    public static String buildLogEntryContact(ActiviteBean activite, String webIdACA) {
        webIdACA = StringUtils.removeStart(webIdACA, SUN_);
        webIdACA = StringUtils.equals(webIdACA, NULL) ? ANONYME : webIdACA;

        StringBuilder sbLogEntry = new StringBuilder();
        sbLogEntry.append(PRISE_CONTACT);
        sbLogEntry.append(PIPE);
        sbLogEntry.append(activite.getWebId());
        sbLogEntry.append(PIPE);
        sbLogEntry.append(activite.getDomainId());
        sbLogEntry.append(PIPE);
        sbLogEntry.append(webIdACA);
        return sbLogEntry.toString();
    }
}
