package fr.toutatice.cartoun.portlet.detailactivite.util;

import org.apache.commons.lang.StringUtils;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;


/**
 * @author dorian
 */
public class VocabularyUtil {

    private VocabularyUtil() {
    }

    /**
     * permet de retrouver la valeur des vocabulaire multi niveau
     * inspiré de VocabularyLabelTag
     *
     * @param nuxeoController
     * @param vocabularyName
     * @param multiLevelKey
     * @return
     */
    public static String getVocabularyEntry(NuxeoController nuxeoController, String vocabularyName, String multiLevelKey) {
        StringBuilder sb = new StringBuilder("");
        String[] keys;
        if (StringUtils.contains(multiLevelKey, "[")) {
            String[] substringsBetween = StringUtils.substringsBetween(multiLevelKey, "[", "]");
            keys = StringUtils.split(substringsBetween[0], ",");
        } else {
            keys = new String[1];
            keys[0] = multiLevelKey;
        }

        for (int i = 0; i < keys.length; i++) {
            if (i > 0) {
                sb.append(", ");
            }

            keys[i] = StringUtils.trim(keys[i]);

            if (StringUtils.contains(keys[i], "/")) {
                String[] subKeys = StringUtils.split(keys[i], "/");

                VocabularyEntry vocabularyEntryRoot = VocabularyHelper.getVocabularyEntry(nuxeoController, vocabularyName, true);

                VocabularyEntry parent = vocabularyEntryRoot.getChild(subKeys[0]);
                if (parent != null) {
                    sb.append(StringUtils.trimToEmpty(parent.getLabel()));
                    VocabularyEntry child = parent.getChild(subKeys[1]);
                    if (child != null) {
                        sb.append(" / ");
                        sb.append(StringUtils.trimToEmpty(child.getLabel()));
                    }
                }
            } else {
                sb.append(StringUtils.trimToEmpty(VocabularyHelper.getVocabularyLabel(nuxeoController, vocabularyName, keys[i])));
            }
        }

        return sb.toString();
    }
}
