/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.cartoun.portlet.detailactivite.util.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import fr.toutatice.cartoun.portlet.detailactivite.bean.ActiviteBean;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import javax.portlet.PortletContext;
import org.apache.commons.io.IOUtils;
import org.osivia.portal.api.internationalization.Bundle;

public class ActiviteFooter
extends PdfPageEventHelper {
    private static final String CC_IMG_URL = "/img/CreativeCommons.png";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("dd MMMMM yyyy");
    private Font defaultFont;
    private Font boldFont;
    private PortletContext portletContext;
    private ActiviteBean activite;
    Bundle bundle;

    public ActiviteFooter(Font defaultFont, Font boldFont, PortletContext portletContext, ActiviteBean activite, Bundle bundle) {
        this.defaultFont = defaultFont;
        this.boldFont = boldFont;
        this.portletContext = portletContext;
        this.activite = activite;
        this.bundle = bundle;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            Phrase date;
            Phrase auteur = new Phrase(this.bundle.getString("label.author"), this.boldFont);
            auteur.add((Element)new Chunk(" : "));
            auteur.add((Element)new Chunk(this.activite.getAuthor(), this.defaultFont));
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)auteur, (float)(document.left() + 70.0f), (float)(document.bottom() - 23.0f), (float)0.0f);
            if (this.activite.getDateModification() != null) {
                date = new Phrase(this.bundle.getString("date.derniere.modification"), this.boldFont);
                date.add((Element)new Chunk(" : "));
                date.add((Element)new Chunk(sdf.format(this.activite.getDatePublication()), this.defaultFont));
                ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)date, (float)(document.left() + 70.0f), (float)(document.bottom() - 35.0f), (float)0.0f);
            } else if (this.activite.getDatePublication() != null) {
                date = new Phrase(this.bundle.getString("date.derniere.publication"), this.boldFont);
                date.add((Element)new Chunk(" : "));
                date.add((Element)new Chunk(sdf.format(this.activite.getDatePublication()), this.defaultFont));
                ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)date, (float)(document.left() + 70.0f), (float)(document.bottom() - 35.0f), (float)0.0f);
            }
            Image ccImage = Image.getInstance((byte[])IOUtils.toByteArray((InputStream)this.portletContext.getResourceAsStream(CC_IMG_URL)));
            ccImage.setAbsolutePosition(document.left() - document.leftMargin() / 2.0f, document.bottom() - (document.bottomMargin() - 10.0f));
            document.add((Element)ccImage);
            Phrase url = new Phrase(20.0f, "http://creativecommons.fr/licences/", this.defaultFont);
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)url, (float)(document.left() + 70.0f), (float)(document.bottom() - 47.0f), (float)0.0f);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }
}

