<%@ page contentType="text/plain; charset=UTF-8"%>
<%@ include file="/WEB-INF/jsp/include.jsp"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="http://www.toutatice.fr/jsp/taglib/toutatice" prefix="ttc"%>



<portlet:defineObjects />

<portlet:actionURL var="becomeReferent">
	<portlet:param name="action" value="becomeReferent" />
</portlet:actionURL>

<portlet:actionURL var="contact">
	<portlet:param name="action" value="toContact" />
</portlet:actionURL>


<c:if test="${activity.displayWarning}">
	<div class="alert alert-warning alert-dismissible" role="alert">
		<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	  <op:translate key="warning.geoloc" />
	</div>
</c:if>

<div class="row">
	<div class="col-sm-2 control-label">${activity.urlVignette}</div>
	<div class="col-sm-10">
		<h3>${activity.title}</h3>
	</div>
</div>


<script>
	function initObjet(val,idx){	
		if(val=='contact'){
			document.getElementById('subject'+idx).value ="Demande d'information sur l'activité Cartoun '${activity.title}'";	
		}else if(val=='rdv'){
			document.getElementById('subject'+idx).value = "Demande de rendez-­vous pour l'activité Cartoun '${activity.title}'";
		}
	};
</script>
<script>
$JQry(function() {
	$JQry(".popover-social").popover({
		trigger: "manual",
		html: true,
		animation: false,
		content: function() {
			var $element = $JQry(this);
			var facebookUrl = $element.data("facebook-url");
			var twitterUrl = $element.data("twitter-url");
			var linkedinUrl = $element.data("linkedin-url");
			var viadeoUrl = $element.data("viadeo-url");
			var viaeducUrl = $element.data("viaeduc-url");
			var content = '';
			if(facebookUrl){
				content += '<a href="'+facebookUrl+'" target="_blank"><img src="/cartoun-detailactivite/img/logo_facebook.svg" height="25"></a>';
			}
			if(twitterUrl){
				content += '<a href="'+twitterUrl+'" target="_blank"><img src="/cartoun-detailactivite/img/logo_twitter.svg" height="25"></a>';
			}
			if(linkedinUrl){
				content += '<a href="'+linkedinUrl+'" target="_blank"><img src="/cartoun-detailactivite/img/logo_linkedin.png" height="25"></a>';
			}
			if(viadeoUrl){
				content += '<a href="'+viadeoUrl+'" target="_blank"><img src="/cartoun-detailactivite/img/logo_viadeo.png" height="25"></a>';
			}
			if(viaeducUrl){
				content += '<a href="'+viaeducUrl+'" target="_blank"><img src="/cartoun-detailactivite/img/logo_viaeduc.png" height="25"></a>';
			}
      		return content;
    	},
    	template: '<div class="popover"><div class="arrow"></div><div class="popover-content"></div></div>'
	}).on("mouseenter", function () {
        var _this = this;
        $JQry(this).popover("show");
        $JQry(".popover").on("mouseleave", function () {
        	setTimeout(function () {
	            if (!$JQry(_this).is(":hover")) {
	                $JQry(_this).popover("hide");
	            }
	        }, 300);
        });
    }).on("mouseleave", function () {
        var _this = this;
        setTimeout(function () {
            if (!$JQry(".popover:hover").length) {
                $JQry(_this).popover("hide");
            }
        }, 300);
	}).on("hide.bs.popover", function () {
		if($JQry(this).is(":hover")){
			e.preventDefault();
			e.stopImmediatePropagation();
		}
	});
});
</script>
<hr>
<div>
	<h4>
		<op:translate key="label.identifiant" />
	</h4>
	<div class="row">
		<div class="col-sm-12">
			<div class="col-sm-12">
				${activity.webId}
				
				<c:if test="${activity.shareable}"><br /><op:translate key="activite.partageable" /></c:if>
				<c:if test="${not activity.shareable}"><br /><op:translate key="activite.non.partageable" /></c:if>
			</div>
		</div>
	</div>
</div>
	
<hr>
<div>
	<h4>
		<op:translate key="label.contact" />
	</h4>
	<c:if test="${connected}">
		<div class="row">
			<c:forEach var="entry" items="${activity.lstReferent1}" varStatus="status">
				<form:form name="actionsForm" method="post" commandName="refForm"
					id="contactLevel1Form" action="${contact}">
					<div class="col-sm-12">
					
						<div class="col-sm-2"> 
							<a class="<c:if test="${not empty entry.socialnetworks}">popover-social</c:if>" 
								<c:forEach var="socialnetwork" items="${entry.socialnetworks}">
										<c:if test="${socialnetwork.name eq 'FACEBOOK'}">
											data-facebook-url="${socialnetwork.url}"
										</c:if>
										<c:if test="${socialnetwork.name eq 'TWITTER'}">
											data-twitter-url="${socialnetwork.url}"
										</c:if>
										<c:if test="${socialnetwork.name eq 'LINKEDIN'}">
											data-linkedin-url="${socialnetwork.url}"
										</c:if>
										<c:if test="${socialnetwork.name eq 'VIADEO'}">
											data-viadeo-url="${socialnetwork.url}"
										</c:if>
										<c:if test="${socialnetwork.name eq 'VIAEDUC'}">
											data-viaeduc-url="${socialnetwork.url}"
										</c:if>
								</c:forEach>
								>${entry.identite}</a>
						</div>
		
						<div class="col-sm-1 ">
							<c:if test="${entry.canDelete}">
		
								<a class="btn btn-xs btn-info" role="button"
									href="<portlet:actionURL><portlet:param name='action' value='deleteReferent' /><portlet:param name='uid' value='${entry.uid}'/>
									</portlet:actionURL>">
									<op:translate key="action.desengager" />
								</a>
		
							</c:if>
						</div>
						<div class="panel-group col-sm-6 panel-inline" id="accordionlevel1${status.index}">
							<div class="col-sm-6 col-sm-offset-0">
								<a class="btn btn-xs btn-info no-ajax-link" role="button"
									data-toggle="collapse" data-parent="#accordionlevel1"
									href="#collapseBodyMailContact" aria-expanded="true"
									aria-controls="collapseOne"> <op:translate key="action.contacter" />
								</a>
							</div>
							<div class="collapse col-sm-9 col-sm-offset-0"	id="collapseBodyMailContact"  style="height: auto; padding:10px; border:1px solid #cccccc; margin: 5px;">
		
								<div class="form-group">
									<form:input readonly="true" type="hidden" path="email" value="${entry.email}" />	
									<div class="form-group">								
										<label class="col-sm-2 control-label">Objet</label>
										<form:input class="form-control col-sm-6" readonly="true" id="subject"	path="subject" value="Demande d'information sur l'activité Cartoun '${activity.title}'"/>									 
									</div>
									<div class="form-group">	
										<label class="col-sm-2 control-label">Message</label>
										<form:textarea class="form-control col-sm-6" id="body" path="bodyMail" />
									</div>
									<span class="input-group-btn col-sm-6" style="padding:5px" >
										<button class="btn btn-xs btn-primary" type="submit" >
											<i class="glyphicons ok_2"></i>Envoyer
										</button>
									</span>
								</div>
		
							</div>
						
						</div>
		
						
					</div>
				</form:form>
			</c:forEach>
		
			<c:if test="${activity.labelReferent2!=null || activity.labelReferent3!=null}">
				<c:forEach var="entry" items="${activity.lstReferent2}" varStatus="status">
					<form:form name="actionsForm" method="post" commandName="refForm"	id="contactLevel2Form" action="${contact}">
						<div class="col-sm-12">
							
							<div class="col-sm-2 col-sm-offset-0"> 
								<a class="<c:if test="${not empty entry.socialnetworks}">popover-social</c:if>" 
									<c:forEach var="socialnetwork" items="${entry.socialnetworks}">
											<c:if test="${socialnetwork.name eq 'FACEBOOK'}">
												data-facebook-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'TWITTER'}">
												data-twitter-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'LINKEDIN'}">
												data-linkedin-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'VIADEO'}">
												data-viadeo-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'VIAEDUC'}">
												data-viaeduc-url="${socialnetwork.url}"
											</c:if>
									</c:forEach>
									>${entry.identite}</a>
							</div>
							
							<div class="col-sm-1 col-sm-offset-0">
								<c:if test="${entry.canDelete}">
		
									<a class="btn btn-xs btn-info" role="button"
										href="<portlet:actionURL><portlet:param name='action' value='deleteReferent' /><portlet:param name='uid' value='${entry.uid}'/>
									</portlet:actionURL>">
										<op:translate key="action.desengager" />
									</a>
		
								</c:if>
							</div>
							<div class="panel-group col-sm-6 col-sm-offset-0" id="accordionlevel2${status.index}">
								
									<div class="col-sm-6 col-sm-offset-0">
										<a class="btn btn-xs btn-info no-ajax-link" role="button"
											data-toggle="collapse" data-parent="accordionlevel2${status.index}"
											href="#collapseBodyMailContact2${status.index}" aria-expanded="true"
											aria-controls="collapseBodyMailContact2${status.index}" onclick="javascript:initObjet('contact',${status.index})"> 
											<op:translate	key="action.contacter" />
										</a>
									
										<a class="btn btn-xs btn-info no-ajax-link" role="button"									
											data-toggle="collapse" data-parent="accordionlevel2${status.index}"
											href="#collapseBodyMailContact2${status.index}"	aria-controls="collapseBodyMailContact2${status.index}" onclick="javascript:initObjet('rdv',${status.index})"> 
											<op:translate	key="action.rdv" />
										</a>
									</div>
									<div class="col-sm-9 col-sm-offset-0 collapse" id="collapseBodyMailContact2${status.index}" style="height: auto; padding:10px; border:1px solid #cccccc; margin: 5px;">
		
										<div class="form-group">
										
											<form:input readonly="true" id="emailh" type="hidden" path="email" value="${entry.email}" />
											<div class="form-group">									
												<label class="col-sm-2 control-label">Objet</label>
												<form:input  class="form-control col-sm-6" readonly="true" id="subject${status.index}" path="subject"   />
											</div>
											<div class="form-group">
												<label class="col-sm-2 control-label">Message</label>
												<form:textarea class="form-control col-sm-6" id="body" path="bodyMail" />
											</div>
											<span class="input-group-btn col-sm-6" style="padding:5px" >
												<button class="btn btn-xs btn-primary" type="submit">
													<i class="glyphicons ok_2"></i>Envoyer
												</button>									
											</span>
										</div>
		
									</div>																		
							</div>					
		
						</div>
					</form:form>
				</c:forEach>
			</c:if>
			<c:if test="${activity.labelReferent3!=null}">
				<c:forEach var="entry" items="${activity.lstReferent3}" varStatus="status">
					<div class="col-sm-12">
						<div class="col-sm-2 col-sm-offset-0"> 
								<a class="<c:if test="${not empty entry.socialnetworks}">popover-social</c:if>" 
									<c:forEach var="socialnetwork" items="${entry.socialnetworks}">
											<c:if test="${socialnetwork.name eq 'FACEBOOK'}">
												data-facebook-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'TWITTER'}">
												data-twitter-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'LINKEDIN'}">
												data-linkedin-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'VIADEO'}">
												data-viadeo-url="${socialnetwork.url}"
											</c:if>
											<c:if test="${socialnetwork.name eq 'VIAEDUC'}">
												data-viaeduc-url="${socialnetwork.url}"
											</c:if>
									</c:forEach>
									>${entry.identite}</a>
							</div>
						
						<div class="col-sm-1 col-sm-offset-0">
							<c:if test="${entry.canDelete}">
								<a class="btn btn-xs btn-info" role="button"
									href="<portlet:actionURL><portlet:param name='action' value='deleteReferent' /><portlet:param name='uid' value='${entry.uid}'/>
									</portlet:actionURL>">
									<op:translate key="action.desengager" />
								</a>
							</c:if>
						</div>				
					</div>
				</c:forEach>
			</c:if>
			<c:if test="${canBecomeReferent}">
				<form:form name="actionsForm" method="post" commandName="refForm"
					id="actionsForm" action="${becomeReferent}">
					<c:choose>
						<c:when test="${beingModified}">
							<div class="col-sm-2 col-sm-offset-10 text-right">
								<p>L'activité est en cours de modification par
									${activity.lastContributor}. Vous ne pouvez devenir référent.</p>
							</div>
						</c:when>
		
						<c:otherwise>
							<div class="col-xs-12 col-sm-5 col-sm-offset-7 col-md-4 col-md-offset-8  col-lg-3 col-lg-offset-9 text-right">
								<p>
									<a class="btn btn-xs btn-info no-ajax-link" data-toggle="collapse" href="#collapseChoiceLevel"
										aria-expanded="false" aria-controls="collapseChoiceLevel"> <op:translate
											key="action.engager" />
									</a>
								</p>
							</div>
		
							<div class="col-xs-12 col-sm-10 col-sm-offset-2 col-md-8 col-md-offset-4 col-lg-6 col-lg-offset-6 collapse"
								id="collapseChoiceLevel">
		
								<div class="input-group">
		
									<form:select style="background: transparent;"
										class="form-control" path="levelSelected">
										<form:options items="${voc}" itemLabel="label" itemValue="id" />
									</form:select>
									<span class="input-group-btn">
										<button class="btn btn-primary" type="submit"
											name="becomeReferent" value="becomeReferent">
											<i class="glyphicons ok_2"></i>Valider
										</button>
									</span>
								</div>
		
							</div>
						</c:otherwise>
					</c:choose>
				</form:form>
			</c:if>
		</div>
	</c:if>
	<c:if test="${not connected}">
		<op:translate key="label.contact.connect" />
	</c:if>
</div>
	

<c:if test="${!empty activity.viaeduc}">
	<div class="form-horizontal">

		<hr>
		<h4>
			<op:translate key="label.viaeduc" />
		</h4>
		<div class="form-group">
			<div class="col-sm-4 col-sm-offset-4">
				<a href="${activity.viaeduc}" target="_blank" class="btn btn-xs btn-info" role="button"><op:translate
						key="label.viaeduc.action" /></a>
			</div>
		</div>

	</div>
</c:if>

<c:if test="${activity.experitheque}">
	<div class="form-horizontal">
		<hr>
		<h4><op:translate key="label.experitheque" /></h4>	
		
			<div class="form-group">
				<div class="col-sm-4 col-sm-offset-4">
					<a class="btn btn-xs btn-info" role="button" href="${activity.urlExpe}" target="_blank" >
						<op:translate key="label.experitheque.action" />
					</a>
				</div>
			</div>						
	</div>
</c:if>

<div class="form-horizontal">
	<hr>
	<h4><op:translate key="label.reperes" /></h4>	
	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate key="label.reperes.principal" /></label>
		<div class="col-sm-8">
			<p class="form-control-static"><ttc:vocabularyLabel name="carto_reperes" key="${activity.reperePrincipal}"/></p>	
		</div>
		<c:if test="${not empty activity.repereOther}">
			<label class="col-sm-4 control-label"><op:translate key="label.reperes.other" /></label>
			<div class="col-sm-8">
				<p class="form-control-static"><ttc:vocabularyLabel name="carto_reperes" key="${activity.repereOther}"/></p>	
			</div>
		</c:if>
	</div>					
</div>

<div class="form-horizontal">
	<hr>
	<h4><op:translate key="label.titre.parcoursAxes" /></h4>
	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.parcours" /></label>
		<div class="col-sm-8">
		<c:choose>
			<c:when test="${empty activity.lstParcours}">					
				<p class="form-control-static"><op:translate key="value.parcours.null" /></p>					
			</c:when>
			<c:otherwise>	
		
			<p class="form-control-static">
				<c:forEach var="entry" items="${activity.lstParcours}">
						<ttc:vocabularyLabel name="carto_parcours" key="${entry}"/> <br />
				</c:forEach>
			</p>
			</c:otherwise>
		</c:choose>	
		</div>
	</div>
	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.axes" /></label>
		<div class="col-sm-8">
		<c:choose>
			<c:when test="${empty activity.lstAxes}">					
				<p class="form-control-static"><op:translate key="value.axes.null" /></p>					
			</c:when>
			<c:otherwise>	
				<p class="form-control-static">
					<c:forEach var="entry" items="${activity.lstAxes}">
							<ttc:vocabularyLabel name="carto_axes" key="${entry}"/> <br />
					</c:forEach>
				</p>
			</c:otherwise>
		</c:choose>
		</div>
	</div>

</div>

<div class="form-horizontal">
	<hr>
	<h4>
		<op:translate key="label.discipline.public" />
	</h4>
	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.discipline" /></label>
		<div class="col-sm-8">
			<p class="form-control-static">
				<c:forEach var="entry" items="${activity.lstDisciplines}">
						<ttc:vocabularyLabel name="disciplines" key="${entry}"/> <br />
				</c:forEach>
			</p>
		</div>
	</div>

	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.public" /></label>
		<div class="col-sm-8">
			<p class="form-control-static">
				<c:forEach var="entry" items="${activity.lstPublics}">
						${entry} <br />
				</c:forEach>
			</p>
		</div>
	</div>

</div>



<div class="form-horizontal">
	<hr>
	<h4><op:translate key="label.description" /></h4>

	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.niveau" /></label>
				<div class="col-sm-8">
				<c:choose>
					<c:when test="${empty activity.level}">					
						<p class="form-control-static"><op:translate key="value.niveau.null" /></p>					
					</c:when>
					<c:otherwise>	
						<p class="form-control-static">${activity.level}</p>					
					 </c:otherwise>
				 </c:choose>
				 </div>
	</div>
	
	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.pratique" /></label>
		<div class="col-sm-8">
		<c:choose>
			<c:when test="${empty activity.lstPractices}">					
				<p class="form-control-static"><op:translate key="value.pratique.null" /></p>					
			</c:when>
			<c:otherwise>	
				<p class="form-control-static">
					<c:forEach var="entry" items="${activity.lstPractices}">
																${entry} <br />
					</c:forEach>
				</p>
			</c:otherwise>
		</c:choose>
		</div>
	</div>
	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.outils" /></label>
		<div class="col-sm-8">
		<c:choose>
			<c:when test="${empty activity.lstTools}">					
				<p class="form-control-static"><op:translate key="value.outils.null" /></p>					
			</c:when>
			<c:otherwise>	
		
				<p class="form-control-static">
					<c:forEach var="entry" items="${activity.lstTools}">
							<ttc:vocabularyLabel name="unu_outils" key="${entry}"/> <br />
					</c:forEach>
				</p>
			</c:otherwise>
		</c:choose>
		</div>
	</div>

	<c:if test="${!empty activity.duration}">
		<div class="form-group">
			<label class="col-sm-4 control-label"><op:translate
					key="label.duree" /></label>
			<div class="col-sm-8">
				<p class="form-control-static">${activity.duration}</p>
			</div>
		</div>
	</c:if>

	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.nature" /></label>
		<div class="col-sm-8">
			<p class="form-control-static">
				<c:forEach var="entry" items="${activity.lstPedagogicals}">
																${entry} <br />
				</c:forEach>
			</p>
		</div>
	</div>
	

	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.modalite" /></label>
		<div class="col-sm-8">
			<p class="form-control-static">
				<c:forEach var="entry" items="${activity.lstCadres}">
															${entry} <br />
				</c:forEach>
			</p>
		</div>
	</div>


	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.lieu" /></label>
		<div class="col-sm-8">
			<p class="form-control-static">
				<c:forEach var="entry" items="${activity.lstPlaces}">
															${entry} <br />
				</c:forEach>
			</p>
		</div>
	</div>



	<c:if test="${!empty activity.lstSoftware}">

		<div class="form-group">
			<label class="col-sm-4 control-label"><op:translate
					key="label.logiciel" /></label>
			<div class="col-sm-8">
				<p class="form-control-static">
					<c:forEach var="entry" items="${activity.lstSoftware}">
																	${entry} <br />
					</c:forEach>
				</p>
			</div>
		</div>

	</c:if>

	<c:if test="${!empty activity.lstESoftware}">

		<div class="form-group">
			<label class="col-sm-4 control-label"><op:translate
					key="label.elogiciel" /></label>
			<div class="col-sm-8">
				<p class="form-control-static">
					<c:forEach var="entry" items="${activity.lstESoftware}">
						<a href="${entry.url}" target="_blank"> ${entry.name}</a>
						<br />
					</c:forEach>
				</p>
			</div>
		</div>

	</c:if>


	<div class="form-group">
		<label class="col-sm-4 control-label"><op:translate
				key="label.transfert" /></label>
		<div class="col-sm-8">
			<p class="form-control-static">${activity.transferability}</p>
		</div>
	</div>



	<c:if test="${!empty activity.lstCompetence}">

		<div class="form-group">
			<label class="col-sm-4 control-label"><op:translate
					key="label.competence" /></label>
			<div class="col-sm-8">
				<p class="form-control-static">
					<c:forEach var="entry" items="${activity.lstCompetence}">
								${entry} <br />
					</c:forEach>
				</p>
			</div>
		</div>

	</c:if>


	<hr>
	<h4>
		<op:translate key="label.resume" />
	</h4>
	<p>${activity.summary}</p>

	<hr>
	<h4>
		<op:translate key="label.scenario" />
	</h4>
	<p>${activity.scenario}</p>


	<hr>
	<h4>
		<op:translate key="label.analyse" />
	</h4>
	<p>${activity.analysis}</p>

	<hr>
	<h4>
		<op:translate key="label.pieges" />
	</h4>
	<p>${activity.trap}</p>




	<c:if test="${!empty activity.pj}">
		<hr>
		<h4><op:translate key="label.files" /></h4>
		<c:if test="${connected}">
			<c:forEach var="pj" items="${activity.pj}">
				<ul>
					<li><a href="${pj.value}" target="_blank">${pj.key}</a></li>
				</ul>
			</c:forEach>
		</c:if>
		<c:if test="${not connected}">
			<op:translate key="label.files.connect" />
		</c:if>
	</c:if>
	


	<div class="bg-info">
		<p>
			<span style="font-weight: bold"><op:translate key="label.author" /> : </span> ${activity.author}</p>
		</p>
		<p>
			<c:if test="${empty activity.datePublication}">
				<span style="font-weight: bold"><op:translate key="date.derniere.modification" /> : </span>
				<fmt:formatDate value="${activity.dateModification}" dateStyle="long" />				
			</c:if>
			<c:if test="${not empty activity.datePublication}">
				<span style="font-weight: bold"><op:translate key="date.derniere.publication" /> : </span>
				<fmt:formatDate value="${activity.datePublication}" dateStyle="long" />
			</c:if>
		</p>

		<a target="#"
			href="http://creativecommons.fr/licences/"> <img
			src="/cartoun-detailactivite/img/CreativeCommons.png"
			style="margin-right: 2px">
			http://creativecommons.fr/licences/
		</a>
	</div>

	<a id="toTopActivite" href="#tetiere">
 		<i class="glyphicons glyphicons-chevron-left rotate90"></i>
	</a>

</div>

