/*
 * Decompiled with CFR 0.152.
 */
package edu.yale.its.tp.cas.client.filter;

import edu.yale.its.tp.cas.client.CASAuthenticationException;
import edu.yale.its.tp.cas.client.CASReceipt;
import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import edu.yale.its.tp.cas.client.Util;
import edu.yale.its.tp.cas.client.filter.CASFilterRequestWrapper;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CASValidateFilter
implements Filter {
    private static Log log = LogFactory.getLog((Class)CASValidateFilter.class);
    public static final String VALIDATE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.validateUrl";
    public static final String SERVICE_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serviceUrl";
    public static final String SERVERNAME_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.serverName";
    public static final String RENEW_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.renew";
    public static final String PROXY_CALLBACK_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.proxyCallbackUrl";
    public static final String WRAP_REQUESTS_INIT_PARAM = "edu.yale.its.tp.cas.client.filter.wrapRequest";
    public static final String CAS_FILTER_NOT_SECURE_MODE = "BROKEN_SECURITY_ALLOW_NON_SSL";
    public static final String NOT_SECURE_DO_NOT_USE_THIS_SETTING_IN_PRODUCTION = "NOT_SECURE_DO_NOT_USE_THIS_SETTING_IN_PRODUCTION";
    public static final String CAS_FILTER_USER = "edu.yale.its.tp.cas.client.filter.user";
    public static final String CAS_FILTER_RECEIPT = "edu.yale.its.tp.cas.client.filter.receipt";
    private String casValidate;
    private String casServiceUrl;
    private String casServerName;
    private String casProxyCallbackUrl;
    private boolean casRenew;
    private boolean wrapRequest;
    private boolean demoMode = false;

    public void init(FilterConfig config) throws ServletException {
        this.casValidate = config.getInitParameter(VALIDATE_INIT_PARAM);
        this.casServiceUrl = config.getInitParameter(SERVICE_INIT_PARAM);
        this.casRenew = Boolean.valueOf(config.getInitParameter(RENEW_INIT_PARAM));
        this.casServerName = config.getInitParameter(SERVERNAME_INIT_PARAM);
        this.casProxyCallbackUrl = config.getInitParameter(PROXY_CALLBACK_INIT_PARAM);
        this.wrapRequest = Boolean.valueOf(config.getInitParameter(WRAP_REQUESTS_INIT_PARAM));
        String insecureModeParamValue = config.getInitParameter(CAS_FILTER_NOT_SECURE_MODE);
        if (insecureModeParamValue != null) {
            if (insecureModeParamValue.equals(NOT_SECURE_DO_NOT_USE_THIS_SETTING_IN_PRODUCTION)) {
                this.demoMode = true;
            } else {
                throw new ServletException("Filter initialization parameter [BROKEN_SECURITY_ALLOW_NON_SSL] had value [" + insecureModeParamValue + "] which is not the magic value [" + NOT_SECURE_DO_NOT_USE_THIS_SETTING_IN_PRODUCTION + "].  Filter initialization failing to avoid accidentally initializing in insecure demo mode." + " Either set the magic value for demo mode or remove this errant parameter entirely.");
            }
        }
        if (this.casServerName != null && this.casServiceUrl != null) {
            throw new ServletException("serverName and serviceUrl cannot both be set: choose one.");
        }
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("one of serverName or serviceUrl must be set.");
        }
        if (this.casServiceUrl != null && !this.casServiceUrl.startsWith("https://") && !this.casServiceUrl.startsWith("http://")) {
            throw new ServletException("service URL must start with http:// or https://; its current value is [" + this.casServiceUrl + "]");
        }
        if (this.casValidate == null) {
            throw new ServletException("validateUrl parameter must be set.");
        }
        if (!this.casValidate.startsWith("https://")) {
            if (this.demoMode) {
                log.warn((Object)("validateUrl normally must start with https://, its current value is [" + this.casValidate + "].  This is VERY INSECURE and NOT APPROPRIATE FOR PRODUCTION USE and is here allowed only because the CASFilter is a not-secure mode."));
            } else {
                throw new ServletException("validateUrl must start with https://, its current value is [" + this.casValidate + "]");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CASValidateFilter initialized as: [" + this.toString() + "]"));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws ServletException, IOException {
        HttpSession session;
        CASReceipt receipt;
        if (log.isTraceEnabled()) {
            log.trace((Object)"entering doFilter()");
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            log.error((Object)"doFilter() called on a request or response that was not an HttpServletRequest or response.");
            throw new ServletException("CASFilter protects only HTTP resources");
        }
        if (this.casProxyCallbackUrl != null && this.casProxyCallbackUrl.endsWith(((HttpServletRequest)request).getRequestURI()) && request.getParameter("pgtId") != null && request.getParameter("pgtIou") != null) {
            log.trace((Object)"passing through what we hope is CAS's request for proxy ticket receptor.");
            fc.doFilter(request, response);
            return;
        }
        if (this.wrapRequest) {
            log.trace((Object)"Wrapping request with CASFilterRequestWrapper.");
            request = new CASFilterRequestWrapper((HttpServletRequest)request);
        }
        if ((receipt = (CASReceipt)(session = ((HttpServletRequest)request).getSession()).getAttribute(CAS_FILTER_RECEIPT)) != null) {
            log.trace((Object)"CAS_FILTER_RECEIPT attribute was present - passing  request through filter..");
            fc.doFilter(request, response);
            return;
        }
        String ticket = request.getParameter("ticket");
        if (ticket == null || ticket.equals("")) {
            log.trace((Object)"CAS ticket was not present on request.");
            fc.doFilter(request, response);
            return;
        }
        try {
            receipt = this.getAuthenticatedUser((HttpServletRequest)request);
        }
        catch (CASAuthenticationException e) {
            log.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        if (session != null) {
            session.setAttribute(CAS_FILTER_USER, (Object)receipt.getUserName());
            session.setAttribute(CAS_FILTER_RECEIPT, (Object)receipt);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("validated ticket to get authenticated receipt [" + receipt + "], now passing request along filter chain."));
        }
        fc.doFilter(request, response);
        log.trace((Object)"returning from doFilter()");
    }

    private CASReceipt getAuthenticatedUser(HttpServletRequest request) throws ServletException, CASAuthenticationException {
        log.trace((Object)"entering getAuthenticatedUser()");
        ProxyTicketValidator pv = null;
        pv = new ProxyTicketValidator();
        pv.setCasValidateUrl(this.casValidate);
        pv.setServiceTicket(request.getParameter("ticket"));
        pv.setService(this.getService(request));
        pv.setRenew(this.casRenew);
        pv.setBrokenSecurityMode(this.demoMode);
        if (this.casProxyCallbackUrl != null) {
            pv.setProxyCallbackUrl(this.casProxyCallbackUrl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("about to validate ProxyTicketValidator: [" + pv + "]"));
        }
        return CASReceipt.getReceipt(pv);
    }

    private String getService(HttpServletRequest request) throws ServletException {
        log.trace((Object)"entering getService()");
        if (this.casServerName == null && this.casServiceUrl == null) {
            throw new ServletException("need one of the following configuration parameters: edu.yale.its.tp.cas.client.filter.serviceUrl or edu.yale.its.tp.cas.client.filter.serverName");
        }
        String serviceString = this.casServiceUrl != null ? URLEncoder.encode(this.casServiceUrl) : Util.getService(request, this.casServerName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("returning from getService() with service [" + serviceString + "]"));
        }
        return serviceString;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[CASValidateFilter:");
        if (this.demoMode) {
            sb.append(" DEMO (NOT-SSL-REQUIRING) MODE IS NOT SECURE AND SHOULD NOT BE USED IN PRODUCTION. ");
        }
        sb.append(" wrapRequest=");
        sb.append(this.wrapRequest);
        sb.append(" casProxyCallbackUrl=[");
        sb.append(this.casProxyCallbackUrl);
        sb.append("]");
        if (this.casRenew) {
            sb.append(" casRenew=true");
        }
        sb.append(" casServerName=[");
        sb.append(this.casServerName);
        sb.append("]");
        sb.append(" casServiceUrl=[");
        sb.append(this.casServiceUrl);
        sb.append("]");
        sb.append(" casValidate=[");
        sb.append(this.casValidate);
        sb.append("]");
        return sb.toString();
    }

    public void destroy() {
    }
}

