/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.util.ContentInfo;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.theme.LayoutException;
import org.jboss.portal.theme.LayoutInfo;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.PortalRenderSet;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.ServerRegistrationID;
import org.jboss.portal.theme.impl.ThemeServiceImpl;
import org.jboss.portal.theme.metadata.PortalLayoutMetaData;
import org.jboss.portal.theme.metadata.RenderSetMetaData;
import org.jboss.portal.theme.metadata.RendererSetMetaData;
import org.jboss.system.Service;

public class LayoutServiceImpl
extends AbstractJBossService
implements LayoutService,
Service {
    private static Logger log = Logger.getLogger(LayoutServiceImpl.class);
    private Map layouts;
    private Map layoutNames;
    private Map exactLayoutNames;
    private Map renderSets;
    private Map renderSetNames;
    private Map exactRenderSetNames;
    private PortalLayout defaultLayout;
    private String defaultName;
    private String defaultRenderSetName;

    public LayoutServiceImpl() {
        log.debug((Object)"LayoutServiceImpl instantiated.");
    }

    protected void createService() throws Exception {
        log.debug((Object)"create LayoutServiceImpl ....");
        this.layouts = Collections.synchronizedMap(new HashMap());
        this.layoutNames = Collections.synchronizedMap(new HashMap());
        this.exactLayoutNames = Collections.synchronizedMap(new HashMap());
        this.renderSets = Collections.synchronizedMap(new HashMap());
        this.renderSetNames = Collections.synchronizedMap(new HashMap());
        this.exactRenderSetNames = Collections.synchronizedMap(new HashMap());
    }

    protected void destroyService() {
        log.debug((Object)"destroy LayoutServiceImpl ....");
        this.layouts.clear();
        this.layoutNames.clear();
        this.exactLayoutNames.clear();
        this.renderSetNames.clear();
        this.exactRenderSetNames.clear();
    }

    protected void startService() throws Exception {
        log.debug((Object)"start LayoutServiceImpl ....");
    }

    protected void stopService() {
        log.debug((Object)"stop LayoutServiceImpl ....");
    }

    public void addLayout(RuntimeContext runtimeContext, PortalLayoutMetaData layoutMD) throws LayoutException {
        try {
            if (layoutMD == null) {
                throw new IllegalArgumentException("Layout metaData is null");
            }
            PortalLayout layout = (PortalLayout)runtimeContext.getClassLoader().loadClass(layoutMD.getClassName()).newInstance();
            log.debug((Object)("adding layout: " + layout));
            LayoutInfo info = new LayoutInfo(runtimeContext, layoutMD);
            layout.init(this, info);
            if (this.layouts == null) {
                this.create();
            }
            this.layouts.put(info.getRegistrationId(), layout);
            this.layoutNames.put(info.getName(), info.getRegistrationId());
            this.exactLayoutNames.put(info.getAppId() + "." + info.getName(), info.getRegistrationId());
        }
        catch (Exception e) {
            throw new LayoutException(e);
        }
    }

    public void setDefaultLayoutName(String name) {
        log.debug((Object)("setting default: " + name));
        this.defaultName = name;
        this.defaultLayout = null;
    }

    public PortalLayout getDefaultLayout() {
        if (this.defaultLayout == null) {
            if (this.exactLayoutNames.keySet().contains(this.defaultName)) {
                ServerRegistrationID defaultID = (ServerRegistrationID)this.exactLayoutNames.get(this.defaultName);
                this.defaultLayout = (PortalLayout)this.layouts.get(defaultID);
            } else if (this.layoutNames.keySet().contains(this.defaultName)) {
                ServerRegistrationID defaultID = (ServerRegistrationID)this.layoutNames.get(this.defaultName);
                this.defaultLayout = (PortalLayout)this.layouts.get(defaultID);
            }
        }
        if (this.defaultLayout == null) {
            log.error((Object)("Couldn't find the default layout named:" + this.defaultName));
        }
        return this.defaultLayout;
    }

    public PortalLayout getLayout(ServerRegistrationID id, boolean defaultOnNull) {
        log.debug((Object)("get " + id + "..."));
        if (id == null) {
            throw new IllegalArgumentException("No null id argument allowed");
        }
        if (!this.layouts.keySet().contains(id) && defaultOnNull) {
            return this.getDefaultLayout();
        }
        return (PortalLayout)this.layouts.get(id);
    }

    public PortalLayout getLayout(String name, boolean defaultOnNull) {
        log.debug((Object)("get " + name + "..."));
        if (this.exactLayoutNames.containsKey(name)) {
            log.debug((Object)("found exact: " + name));
            return (PortalLayout)this.layouts.get(this.exactLayoutNames.get(name));
        }
        if (this.layoutNames.containsKey(name)) {
            log.debug((Object)("found " + name));
            return (PortalLayout)this.layouts.get(this.layoutNames.get(name));
        }
        if (defaultOnNull) {
            log.debug((Object)("try to return default " + name));
            return this.getDefaultLayout();
        }
        log.debug((Object)("oops , not found " + name));
        return null;
    }

    public PortalLayout getLayoutById(String layoutIdString) {
        PortalLayout layout;
        if (layoutIdString == null) {
            layout = this.getDefaultLayout();
        } else if (layoutIdString.lastIndexOf(".") > 0) {
            ServerRegistrationID layoutID = ServerRegistrationID.createID(ServerRegistrationID.TYPE_LAYOUT, ThemeServiceImpl.parseId(layoutIdString));
            layout = this.getLayout(layoutID, true);
        } else {
            layout = this.getLayout(layoutIdString, true);
        }
        if (layout == null) {
            layout = this.getLayout("generic", true);
        }
        if (layout == null) {
            throw new IllegalStateException("NO LAYOUT FOUND FOR " + layoutIdString);
        }
        return layout;
    }

    public void removeLayout(ServerRegistrationID id) throws LayoutException {
        log.debug((Object)("removing layout with id: " + id));
        if (id == null) {
            throw new IllegalArgumentException("No null id argument allowed");
        }
        PortalLayout layout = (PortalLayout)this.layouts.get(id);
        if (layout == null) {
            log.debug((Object)"Not found. Nothing to remove.");
            return;
        }
        LayoutInfo info = layout.getLayoutInfo();
        String layoutName = info.getAppId() + "." + info.getName();
        if (this.exactLayoutNames.keySet().contains(layoutName)) {
            log.debug((Object)("removing layout exact " + layoutName));
            this.exactLayoutNames.remove(layoutName);
        }
        if (this.layoutNames.keySet().contains(info.getName()) && id.equals(this.layoutNames.get(info.getName()))) {
            log.debug((Object)("removing layout " + info.getName()));
            this.layoutNames.remove(info.getName());
        }
        this.layouts.remove(id);
        layout.destroy();
        if (this.getDefaultLayout() != null && this.getDefaultLayout().equals(layout)) {
            log.debug((Object)"removed default layout, need to set new one...");
            Iterator i = this.layouts.keySet().iterator();
            if (i.hasNext()) {
                ServerRegistrationID defaultID = (ServerRegistrationID)i.next();
                this.defaultLayout = layout = (PortalLayout)this.layouts.get(defaultID);
                this.defaultName = layout.getLayoutInfo().getName();
                log.debug((Object)("set default layout to " + layout.getLayoutInfo().getAppId() + "." + layout.getLayoutInfo().getName()));
            } else {
                this.defaultLayout = null;
                this.defaultName = null;
            }
        }
    }

    public void removeLayouts(String appID) throws LayoutException {
        ArrayList<ServerRegistrationID> layoutsToDelete = new ArrayList<ServerRegistrationID>();
        for (ServerRegistrationID id : this.layouts.keySet()) {
            PortalLayout layout = (PortalLayout)this.layouts.get(id);
            if (!layout.getLayoutInfo().getAppId().equals(appID)) continue;
            layoutsToDelete.add(id);
        }
        Iterator toDelete = layoutsToDelete.iterator();
        while (toDelete.hasNext()) {
            this.removeLayout((ServerRegistrationID)toDelete.next());
        }
    }

    public void addRenderSet(RuntimeContext runtimeContext, RenderSetMetaData renderSetMD) throws LayoutException {
        try {
            for (RendererSetMetaData rendererSetMD : renderSetMD.getRendererSet()) {
                PortalRenderSet renderSet = new PortalRenderSet(renderSetMD.getName(), runtimeContext, rendererSetMD);
                log.debug((Object)("adding : " + renderSet.getRegistrationId()));
                HashMap<MediaType, PortalRenderSet> sets = (HashMap<MediaType, PortalRenderSet>)this.renderSets.get(renderSet.getRegistrationId());
                if (sets == null) {
                    sets = new HashMap<MediaType, PortalRenderSet>();
                    this.renderSets.put(renderSet.getRegistrationId(), sets);
                }
                sets.put(renderSet.getMediaType(), renderSet);
                this.renderSetNames.put(renderSet.getName(), renderSet.getRegistrationId());
                this.exactRenderSetNames.put(renderSet.getAppId() + "." + renderSet.getName(), renderSet.getRegistrationId());
            }
        }
        catch (Exception e) {
            throw new LayoutException(e);
        }
    }

    public PortalRenderSet getRenderSet(String renderSetName, MediaType mediaType) {
        ServerRegistrationID id = (ServerRegistrationID)this.exactRenderSetNames.get(renderSetName);
        if (id == null) {
            id = (ServerRegistrationID)this.renderSetNames.get(renderSetName);
        }
        return this.getRenderSet(id, mediaType);
    }

    public PortalRenderSet getRenderSet(ServerRegistrationID id, MediaType mediaType) {
        if (id != null) {
            Map sets = (Map)this.renderSets.get(id);
            return (PortalRenderSet)sets.get(mediaType);
        }
        return null;
    }

    public void removeRenderSets(String appId) throws LayoutException {
        log.debug((Object)("removing named render sets for : " + appId));
        ArrayList<ServerRegistrationID> renderSetsToDelete = new ArrayList<ServerRegistrationID>();
        for (ServerRegistrationID id : this.renderSets.keySet()) {
            if (!appId.equals(id.getName(0))) continue;
            renderSetsToDelete.add(id);
        }
        for (ServerRegistrationID id : renderSetsToDelete) {
            this.renderSets.remove(id);
            String key = id.getName(0) + "." + id.getName(1);
            log.debug((Object)("removing render sets: " + key));
            this.exactRenderSetNames.remove(key);
            if (!id.equals(this.renderSetNames.get(id.getName(1)))) continue;
            this.renderSetNames.remove(id.getName(1));
        }
    }

    public Collection getLayouts() {
        return Collections.unmodifiableCollection(this.layouts.values());
    }

    public Collection getRenderSets() {
        return Collections.unmodifiableCollection(this.renderSetNames.values());
    }

    public void setDefaultRenderSetName(String name) {
        log.debug((Object)("setting default render set: " + name));
        this.defaultRenderSetName = name;
    }

    public String getDefaultRenderSetName() {
        return this.defaultRenderSetName;
    }

    public PortalRenderSet getRenderSet(LayoutInfo info, ContentInfo streamInfo, String renderSetName) {
        if (renderSetName == null) {
            renderSetName = this.getDefaultRenderSetName();
        }
        if (info == null || renderSetName == null || streamInfo == null) {
            throw new IllegalArgumentException("No null arguments allowed [" + info + "] [" + renderSetName + "] [" + streamInfo + "]");
        }
        MediaType mediaType = streamInfo.getMediaType();
        return this.getRenderSet(renderSetName, mediaType);
    }
}

