/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.RegistryCleaner;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.ticket.registry.support.LockingStrategy;
import org.jasig.cas.ticket.registry.support.NoOpLockingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTicketRegistryCleaner
implements RegistryCleaner {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private TicketRegistry ticketRegistry;
    @NotNull
    private LockingStrategy lock = new NoOpLockingStrategy();
    private boolean logUserOutOfServices = true;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void clean() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        DefaultTicketRegistryCleaner.clean_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setLock(LockingStrategy strategy) {
        this.lock = strategy;
    }

    public void setLogUserOutOfServices(boolean logUserOutOfServices) {
        this.logUserOutOfServices = logUserOutOfServices;
    }

    static {
        Factory factory = new Factory("DefaultTicketRegistryCleaner.java", Class.forName("org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clean", "org.jasig.cas.ticket.registry.support.DefaultTicketRegistryCleaner", "", "", "", "void"), 70);
    }

    private static final /* synthetic */ void clean_aroundBody0(DefaultTicketRegistryCleaner ajc$this, JoinPoint joinPoint) {
        ajc$this.log.info("Beginning ticket cleanup.");
        ajc$this.log.debug("Attempting to acquire ticket cleanup lock.");
        if (!ajc$this.lock.acquire()) {
            ajc$this.log.info("Could not obtain lock.  Aborting cleanup.");
            return;
        }
        ajc$this.log.debug("Acquired lock.  Proceeding with cleanup.");
        try {
            ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
            Collection<Ticket> ticketsInCache = ajc$this.ticketRegistry.getTickets();
            for (Ticket ticket : ticketsInCache) {
                if (!ticket.isExpired()) continue;
                ticketsToRemove.add(ticket);
            }
            ajc$this.log.info(String.valueOf(ticketsToRemove.size()) + " tickets found to be removed.");
            for (Ticket ticket : ticketsToRemove) {
                if (ajc$this.logUserOutOfServices && ticket instanceof TicketGrantingTicket) {
                    ((TicketGrantingTicket)ticket).expire();
                }
                ajc$this.ticketRegistry.deleteTicket(ticket.getId());
            }
        }
        finally {
            ajc$this.log.debug("Releasing ticket cleanup lock.");
            ajc$this.lock.release();
        }
        ajc$this.log.info("Finished ticket cleanup.");
    }

    private static final /* synthetic */ Object clean_aroundBody1$advice(DefaultTicketRegistryCleaner ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Object object;
        Object returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            DefaultTicketRegistryCleaner.clean_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
            object = returnVal = null;
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return object;
    }
}

