package fr.toutatice.cartoun.generator.model;

import java.util.List;

/**
 * Generator configuration java-bean.
 *
 * @author Cédric Krommenhoek
 */
public class Configuration {

    /** Academies. */
    private List<Academy> academies;
    /** Pools count. */
    private Integer poolsCount;
    /** Institutions count. */
    private Integer institutionsCount;
    /** Profiles base DN. */
    private String profilesBaseDn;
    /** Disciplines. */
    private List<String> disciplines;
    /** Profiles. */
    private List<String> profiles;
    /** Users base DN. */
    private String usersBaseDn;
    /** Users count. */
    private Integer usersCount;
    /** Folders count. */
    private Integer foldersCount;
    /** Activities count. */
    private Integer activitiesCount;
    /** Referrers count. */
    private Integer referrersCount;


    /**
     * Constructor.
     */
    public Configuration() {
        super();
    }


    /**
     * Getter for academies.
     *
     * @return the academies
     */
    public List<Academy> getAcademies() {
        return this.academies;
    }

    /**
     * Setter for academies.
     *
     * @param academies the academies to set
     */
    public void setAcademies(List<Academy> academies) {
        this.academies = academies;
    }

    /**
     * Getter for poolsCount.
     *
     * @return the poolsCount
     */
    public Integer getPoolsCount() {
        return this.poolsCount;
    }

    /**
     * Setter for poolsCount.
     *
     * @param poolsCount the poolsCount to set
     */
    public void setPoolsCount(Integer poolsCount) {
        this.poolsCount = poolsCount;
    }

    /**
     * Getter for institutionsCount.
     *
     * @return the institutionsCount
     */
    public Integer getInstitutionsCount() {
        return this.institutionsCount;
    }

    /**
     * Setter for institutionsCount.
     *
     * @param institutionsCount the institutionsCount to set
     */
    public void setInstitutionsCount(Integer institutionsCount) {
        this.institutionsCount = institutionsCount;
    }

    /**
     * Getter for profilesBaseDn.
     * 
     * @return the profilesBaseDn
     */
    public String getProfilesBaseDn() {
        return profilesBaseDn;
    }

    /**
     * Setter for profilesBaseDn.
     * 
     * @param profilesBaseDn the profilesBaseDn to set
     */
    public void setProfilesBaseDn(String profilesBaseDn) {
        this.profilesBaseDn = profilesBaseDn;
    }

    /**
     * Getter for disciplines.
     * 
     * @return the disciplines
     */
    public List<String> getDisciplines() {
        return disciplines;
    }

    /**
     * Setter for disciplines.
     * 
     * @param disciplines the disciplines to set
     */
    public void setDisciplines(List<String> disciplines) {
        this.disciplines = disciplines;
    }

    /**
     * Getter for profiles.
     * 
     * @return the profiles
     */
    public List<String> getProfiles() {
        return profiles;
    }

    /**
     * Setter for profiles.
     * 
     * @param profiles the profiles to set
     */
    public void setProfiles(List<String> profiles) {
        this.profiles = profiles;
    }

    /**
     * Getter for usersBaseDn.
     *
     * @return the usersBaseDn
     */
    public String getUsersBaseDn() {
        return this.usersBaseDn;
    }

    /**
     * Setter for usersBaseDn.
     *
     * @param usersBaseDn the usersBaseDn to set
     */
    public void setUsersBaseDn(String usersBaseDn) {
        this.usersBaseDn = usersBaseDn;
    }

    /**
     * Getter for usersCount.
     *
     * @return the usersCount
     */
    public Integer getUsersCount() {
        return this.usersCount;
    }

    /**
     * Setter for usersCount.
     *
     * @param usersCount the usersCount to set
     */
    public void setUsersCount(Integer usersCount) {
        this.usersCount = usersCount;
    }

    /**
     * Getter for foldersCount.
     *
     * @return the foldersCount
     */
    public Integer getFoldersCount() {
        return this.foldersCount;
    }

    /**
     * Setter for foldersCount.
     *
     * @param foldersCount the foldersCount to set
     */
    public void setFoldersCount(Integer foldersCount) {
        this.foldersCount = foldersCount;
    }

    /**
     * Getter for activitiesCount.
     *
     * @return the activitiesCount
     */
    public Integer getActivitiesCount() {
        return this.activitiesCount;
    }

    /**
     * Setter for activitiesCount.
     *
     * @param activitiesCount the activitiesCount to set
     */
    public void setActivitiesCount(Integer activitiesCount) {
        this.activitiesCount = activitiesCount;
    }

    /**
     * Getter for referrersCount.
     * 
     * @return the referrersCount
     */
    public Integer getReferrersCount() {
        return this.referrersCount;
    }

    /**
     * Setter for referrersCount.
     * 
     * @param referrersCount the referrersCount to set
     */
    public void setReferrersCount(Integer referrersCount) {
        this.referrersCount = referrersCount;
    }

}
