package fr.toutatice.cartoun.racvisiontest;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.directory.IDirectoryServiceLocator;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;


/**
 * Classe de test de la connexion au LDAP depuis le portail cartoun
 *
 * @author dorian
 */
public class LDAPRacvisionTest extends AbstractRacVisionTest {

    private static final Log LOGGER = LogFactory.getLog(NuxeoRacvisionTest.class);

    private IDirectoryServiceLocator directoryServiceLocator;


    public LDAPRacvisionTest(IDirectoryServiceLocator directoryServiceLocator, String idTest, boolean required, String description, boolean duration) {
        setDirectoryServiceLocator(directoryServiceLocator);
        setValeur(idTest, required, description, duration);
    }

    @Override
    public List<RacVisionTestResult> run() {

        List<RacVisionTestResult> resultats = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult resultat = new RacVisionTestResult(getId(), isRequired(), getDescription());
        resultats.add(resultat);
        resultat.setState(new State(TestResultStateEnum.CRIT, "Connexion à Nuxeo impossible."));
        List<String> listParamAbsent = new ArrayList<String>();
        if (this.directoryServiceLocator == null) {
            listParamAbsent.add("accès au directory service");
        }
        if (!listParamAbsent.isEmpty()) {
            StringBuffer message = new StringBuffer(
                    "Au moins un paramètre attendu par la méthode est absent, le test n'a pu être réalisé. Paramètre(s) manquant(s) : ");
            for (String paramAbsent : listParamAbsent) {
                message.append(paramAbsent).append(", ");
            }
            String strMsg = message.substring(0, message.length() - 2);
            resultat.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
            return resultats;
        }

        try {
            String randomUid = String.valueOf(RandomUtils.nextLong());
            getDirectoryServiceLocator().getDirectoryService().getPerson(randomUid);
            resultat.setState(new State(TestResultStateEnum.OK));
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            resultat.setState(new State(TestResultStateEnum.CRIT, "Impossible d'exécuter une requête LDAP."));
        }

        return resultats;
    }

    /**
     * Getter for directoryServiceLocator.
     *
     * @return the directoryServiceLocator
     */
    public IDirectoryServiceLocator getDirectoryServiceLocator() {
        return directoryServiceLocator;
    }

    /**
     * Setter for directoryServiceLocator.
     *
     * @param directoryServiceLocator the directoryServiceLocator to set
     */
    public void setDirectoryServiceLocator(IDirectoryServiceLocator directoryServiceLocator) {
        this.directoryServiceLocator = directoryServiceLocator;
    }

}
