package fr.toutatice.cartoun.racvisiontest;

import java.util.ArrayList;
import java.util.List;

import javax.portlet.PortletContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.portal.api.cache.services.CacheInfo;

import fr.edu.toulouse.commons.racvision.report.TestResultStateEnum;
import fr.edu.toulouse.commons.racvision.test.AbstractRacVisionTest;
import fr.edu.toulouse.commons.racvision.test.RacVisionTestResult;
import fr.edu.toulouse.commons.racvision.test.State;
import fr.toutatice.cartoun.command.TestNuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;


/**
 * Classe de test de la connexion à Nuxeo depuis le portail cartoun
 *
 * @author dorian
 */
public class NuxeoRacvisionTest extends AbstractRacVisionTest {

    private static final Log LOGGER = LogFactory.getLog(NuxeoRacvisionTest.class);

    private final PortletContext portletContext;
    private boolean isElasticSearch;

    public NuxeoRacvisionTest(PortletContext portletContext, boolean isElasticSearch, String idTest, boolean required, String description, boolean duration) {
        this.portletContext = portletContext;
        setElasticSearch(isElasticSearch);
        setValeur(idTest, required, description, duration);
    }

    @Override
    public List<RacVisionTestResult> run() {
        List<RacVisionTestResult> resultats = new ArrayList<RacVisionTestResult>();
        RacVisionTestResult resultat = new RacVisionTestResult(getId(), isRequired(), getDescription());
        resultats.add(resultat);
        resultat.setState(new State(TestResultStateEnum.CRIT, "Connexion à Nuxeo impossible."));
        List<String> listParamAbsent = new ArrayList<String>();
        if (this.portletContext == null) {
            listParamAbsent.add("contexte de connexion à Nuxeo");
        }
        if (!listParamAbsent.isEmpty())
        {
          StringBuffer message = new StringBuffer(
            "Au moins un paramètre attendu par la méthode est absent, le test n'a pu être réalisé. Paramètre(s) manquant(s) : ");
          for (String paramAbsent : listParamAbsent) {
            message.append(paramAbsent).append(", ");
          }
          String strMsg = message.substring(0, message.length() - 2);
          resultat.setState(new State(TestResultStateEnum.CRIT, strMsg + "."));
          return resultats;
        }
        try {
            NuxeoController nuxeoController = new NuxeoController(portletContext);
            nuxeoController.startNuxeoService();
            nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_ANONYMOUS);
            nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);

            Object root = nuxeoController.executeNuxeoCommand(new TestNuxeoCommand(isElasticSearch()));
            if (root != null) {
                resultat.setState(new State(TestResultStateEnum.OK));
            }
        } catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
            resultat.setState(new State(TestResultStateEnum.CRIT, "Impossible d'exécuter une requête Nuxeo."));
        }

        return resultats;
    }

    /**
     * Getter for portletContext.
     *
     * @return the portletContext
     */
    public PortletContext getPortletContext() {
        return portletContext;
    }

    /**
     * Getter for isElasticSearch.
     *
     * @return the isElasticSearch
     */
    public boolean isElasticSearch() {
        return isElasticSearch;
    }

    /**
     * Setter for isElasticSearch.
     *
     * @param isElasticSearch the isElasticSearch to set
     */
    public void setElasticSearch(boolean isElasticSearch) {
        this.isElasticSearch = isElasticSearch;
    }

}
