package fr.toutatice.services.calendar.batch.command;


import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;

import java.util.UUID;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Constants;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Documents;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;

/**
 * List Nuxeo events command.
 *
 * @author Cédric Krommenhoek
 * @author Julien Barberet
 * @see INuxeoCommand
 */
public class ListInteractikAgendaCommand implements INuxeoCommand {
	
    /** Nuxeo query filter context. */
    private NuxeoQueryFilterContext queryContext;
    /** logger */
    protected static final Log logger = LogFactory.getLog(ListInteractikAgendaCommand.class);

    /**
     * Constructor.
     *
     * @param queryContext Nuxeo query filter context
     * @param contextPath context path
     * @param startDate start date
     * @param endDate end date
     */
    public ListInteractikAgendaCommand(NuxeoQueryFilterContext queryContext) {
        super();
        this.queryContext = queryContext;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Object execute(Session nuxeoSession) throws Exception {
    	//List event in Nuxeo that were previously synchronized from the idAgenda source
    	Documents documents = (Documents) list(nuxeoSession);

    	return documents;
    }

    /**
     * List event in Nuxeo that were previously synchronized from the idAgenda source
     * @param nuxeoSession
     * @return
     * @throws Exception
     */
    private Object list(Session nuxeoSession) throws Exception
    {
    	// Clause
        StringBuilder clause = new StringBuilder();
        clause.append(" ecm:primaryType='"+AGENDA_INTERACTIK+"' ");
        clause.append(" AND (cal:sources is not null) ");

        // Filter on published documents
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter(this.queryContext, clause.toString());

        // Request
        OperationRequest request;
        request = nuxeoSession.newRequest("Document.Query");
        request.setHeader(Constants.HEADER_NX_SCHEMAS, "*");

        request.set("query", "SELECT * FROM Document WHERE " + filteredRequest);

        return request.execute();
    }
    


    /**
     * {@inheritDoc}
     */
    @Override
    public String getId() {
        return UUID.randomUUID().toString();
    }

}