package fr.toutatice.services.calendar.common.repository;

import javax.portlet.PortletException;

import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.springframework.stereotype.Repository;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;

@Repository
public class CommonCalendarRepositoryImpl implements CommonCalendarRepository {

	@Override
	public boolean isInInteractikAgenda(Document document, PortalControllerContext portalControllerContext) throws PortletException {
		// Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        
        String parentPath = NuxeoController.getParentPath(document.getPath());
        
        // Nuxeo document context
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(parentPath);
        
        Document documentParent = documentContext.getDocument();
        
        return AGENDA_INTERACTIK.equals(documentParent.getType());
	}

}
