package fr.toutatice.services.calendar.edition.portlet.controller;

import java.io.IOException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.services.calendar.edition.portlet.controller.CalendarEditionController;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.portlet.bind.annotation.ActionMapping;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.services.calendar.edition.portlet.model.EventFromExcel;
import fr.toutatice.services.calendar.edition.portlet.model.InteractikCalendarEditionForm;
import fr.toutatice.services.calendar.edition.portlet.repository.command.InteractikImportEventsFromExcelCommand;

/**
 * Interactik Calendar edition portlet controller.
 * 
 * @author Julien Barberet
 */
@Controller
@RequestMapping("VIEW")
@SessionAttributes("form")
@Primary
public class InteractikCalendarEditionController extends CalendarEditionController{

	/** Internationalization bundle factory. */
    @Autowired
    private IBundleFactory bundleFactory;
    
    private static final String DATE_FORMAT = "dd/MM/yy";
    
    private static final String DATE_TIME_FORMAT = "dd/MM/yy HH:mm:ss";
    
    /** Notifications service. */
    @Autowired
    private INotificationsService notificationsService;
	
    private static final String[] excelMimeTypes = new String[] {"application/vnd.ms-excel",
    		"application/msexcel",
    		"application/x-msexcel",
    		"application/x-ms-excel",
    		"application/x-excel",
    		"application/x-dos_ms_excel",
    		"application/xls",
    		"application/x-xls",
    		"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    		"application/vnd.oasis.opendocument.spreadsheet",
    		"application/vnd-xls",
    		"application/vnd.ms-excel",
    		"application/octet-stream",
    		"text/xls",
    		"text/csv"};
    /**
     * Constructor.
     */
    public InteractikCalendarEditionController() {
        super();
    }


    /**
     * Upload vignette action mapping.
     * 
     * @param request action request
     * @param response action response
     * @param form calendar form model attribute
     * @throws PortletException
     * @throws IOException
     */
    @ActionMapping(name = "save", params = "import-submit")
    public void uploadVignette(ActionRequest request, ActionResponse response, @ModelAttribute("form") CalendarEditionForm form)
            throws PortletException, IOException {

    	// Locale
        Locale locale = request.getLocale();
        // Internationalization bundle
        Bundle bundle = this.bundleFactory.getBundle(locale);
        
        // Portal controller context
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
    	
    	MultipartFile upload = ((InteractikCalendarEditionForm) form).getUploadedTemporaryFile();
    	// Upload file mime type
		MimeType mimeType = null;
    	if (upload != null)
    	{
            try {
                mimeType = new MimeType(upload.getContentType());
            } catch (MimeTypeParseException e) {
                mimeType = null;
            }
    	}
    	boolean isExcelMime = false;
    	if (mimeType != null)
    	{
    		for (String excelMime : excelMimeTypes)
    		{
    			try {
					if (mimeType.match(excelMime))
					{
						isExcelMime = true;
						break;
					}
				} catch (MimeTypeParseException e) {
					// Do nothing
				}
    		}
    		
    	}
    	if (isExcelMime)
		{
			boolean error = false;
//			InputStreamReader reader = new InputStreamReader(upload.getInputStream());
//			CSVFormat csvFormat = CSVFormat.EXCEL.withHeader("dateBegin","dateEnd","allday","timeBegin","timeEnd","department","ville","location","dateDebutInscription","dateFinInscription","urlInscription");
//			
			CSVParser parser = CSVParser.parse(upload.getInputStream(), Charset.defaultCharset(), CSVFormat.EXCEL);
			List<EventFromExcel> events = new ArrayList<>();
			for (CSVRecord csvRecord : parser) {
				if (!"startDate".equals(csvRecord.get(0)))
				{
					try {
						events.add(buildEvent(csvRecord, bundle));
					} catch (ParseException e) {
						events = new ArrayList<>();
						// Notification
				        this.notificationsService.addSimpleNotification(portalControllerContext, e.getMessage(), NotificationsType.ERROR);
				        error = true;
				        break;
					}
				}
			}
			parser.close();
			if (!error)
			{
				//Save events in Nuxeo
				// Nuxeo controller
		        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);

		        // CMS path
		        String cmsPath = this.getCMSPath(nuxeoController);
		        String parentPath = nuxeoController.getContentPath();

		        INuxeoCommand nuxeoCommand = new InteractikImportEventsFromExcelCommand(cmsPath, parentPath, events);
		        nuxeoController.executeNuxeoCommand(nuxeoCommand);
		        this.notificationsService.addSimpleNotification(portalControllerContext, bundle.getString("TIK_SUCCESS_IMPORT_EXCEL",events.size()), NotificationsType.SUCCESS);
			}
		} else
		{
			// Notification
	        String message = bundle.getString("TIK_WRONG_FORMAT_FILE_TO_IMPORT");
	        this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
		}
    	
    }
    
    private EventFromExcel buildEvent(CSVRecord csvRecord, Bundle bundle) throws ParseException{
        boolean allDay = false;
    	if (StringUtils.isNotEmpty(csvRecord.get(2))) allDay = BooleanUtils.toBoolean(csvRecord.get(2));

        SimpleDateFormat format = new SimpleDateFormat(DATE_TIME_FORMAT);
        Date startDate;
        Date endDate;
        if (allDay)
        {
        	try {
				startDate = format.parse(csvRecord.get(0)+" 00:00:00");
			} catch (ParseException e) {
				throw new ParseException(bundle.getString("TIK_PARSE_ERROR_START_DATE"), 0);
			}
        	try {
				endDate = format.parse(csvRecord.get(1)+" 00:00:00");
			} catch (ParseException e) {
				throw new ParseException(bundle.getString("TIK_PARSE_ERROR_END_DATE"), 0);
			}
        } else
        {
        	try {
				startDate = format.parse(csvRecord.get(0)+" "+csvRecord.get(3));
			} catch (ParseException e) {
				throw new ParseException(bundle.getString("TIK_PARSE_ERROR_START_DATE_TIME"), 0);
			}
        	try {
				endDate = format.parse(csvRecord.get(1)+" "+csvRecord.get(4));
			} catch (ParseException e) {
				throw new ParseException(bundle.getString("TIK_PARSE_ERROR_END_DATE_TIME"), 0);
			}
        }
        String title = csvRecord.get(5);
        String description = csvRecord.get(6);
        String codeDept = csvRecord.get(7);
        if (StringUtils.isEmpty(codeDept)) throw new ParseException(bundle.getString("TIK_PARSE_ERROR_CODE_DEPT"), 0);
        
        String city = csvRecord.get(8);
        String location = csvRecord.get(9);
        
        String strStartRegistration = csvRecord.get(10);
        format = new SimpleDateFormat(DATE_FORMAT);
        Date startDateRegistration = null;
        if (StringUtils.isNotEmpty(strStartRegistration))
			try {
				startDateRegistration = format.parse(strStartRegistration);
			} catch (ParseException e) {
				throw new ParseException(bundle.getString("TIK_PARSE_ERROR_START_DATE_REGISTRATION"), 0);
			}
        Date endDateRegistration;
		try {
			endDateRegistration = format.parse(csvRecord.get(11));
		} catch (ParseException e) {
			throw new ParseException(bundle.getString("TIK_PARSE_ERROR_END_DATE_REGISTRATION"), 0);
		}
        String urlRegistration = csvRecord.get(12);


        return new EventFromExcel(title,startDate, endDate, allDay, description, codeDept, city, location, startDateRegistration, endDateRegistration, urlRegistration);
    }
    
    /**
     * Get CMS path.
     *
     * @param nuxeoController Nuxeo controller
     * @return CMS path
     * @throws PortletException
     */
    protected String getCMSPath(NuxeoController nuxeoController) throws PortletException {

        // Context path
        String cmsPath;
         // Current window
        PortalWindow window = WindowFactory.getWindow(nuxeoController.getRequest());

        cmsPath = window.getPageProperty("osivia.cms.basePath");

        return nuxeoController.getComputedPath(cmsPath);
    }

}
