package fr.toutatice.services.calendar.edition.portlet.repository.command;


import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DATE_DEBUT_INSCRIPTION_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DATE_FIN_INSCRIPTION_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DEPARTEMENT_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DOCUMENT_TYPE_EVENT_INTERACTIK;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.IMPORTED_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.URL_INSCRIPTION_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.VILLE_PROPERTY;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.services.calendar.edition.portlet.model.EventFromExcel;

/**
 * Save events from Excel into Nuxeo command.
 *
 * @author Julien Barberet
 * @see INuxeoCommand
 */
public class InteractikImportEventsFromExcelCommand implements INuxeoCommand {

    /** Context path. */
    private final String contextPath;
    /** List of event to synchronize */
    private List<EventFromExcel> eventsList;

    private final String parentPath;
    /** logger */
    protected static final Log logger = LogFactory.getLog(InteractikImportEventsFromExcelCommand.class);

    /**
     * Constructor.
     *
     * @param queryContext Nuxeo query filter context
     * @param contextPath context path
     * @param startDate start date
     * @param endDate end date
     */
    public InteractikImportEventsFromExcelCommand(String contextPath, String parentPath, List<EventFromExcel> eventsList) {
        super();
        this.contextPath = contextPath;
        this.eventsList = eventsList;
        this.parentPath = parentPath;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Object execute(Session nuxeoSession) throws Exception {
    	DocumentService documentService = nuxeoSession.getAdapter(DocumentService.class);
    	PropertyMap map;
    	for (EventFromExcel eventToCreate : eventsList)
    	{
			map = fillMap(eventToCreate);
			documentService.createDocument(new DocRef(this.parentPath), DOCUMENT_TYPE_EVENT_INTERACTIK, null, map, true);
    	}

    	return null;
    }

   
    private PropertyMap fillMap(EventFromExcel event) throws JsonGenerationException, JsonMappingException, IOException
    {
        PropertyMap map = new PropertyMap();

        if (event.isAllDay())
        {
	        map.set(CalendarViewRepository.END_DATE_PROPERTY, formatDate(event.getEndDate()));
	        map.set(CalendarViewRepository.START_DATE_PROPERTY, formatDate(event.getStartDate()));
        }
        else
        {
	        map.set(CalendarViewRepository.END_DATE_PROPERTY, event.getEndDate());
	        map.set(CalendarViewRepository.START_DATE_PROPERTY, event.getStartDate());
        }
        map.set(CalendarViewRepository.TITLE_PROPERTY, event.getTitle());
        map.set(CalendarViewRepository.DESCRIPTION_PROPERTY, event.getDescription());
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getDefault());
        map.set(CalendarViewRepository.CREATED_SOURCE, cal.getTime());
        map.set(CalendarViewRepository.LAST_MODIFIED_SOURCE, cal.getTime());
        map.set(CalendarViewRepository.ALL_DAY_PROPERTY,event.isAllDay());
        map.set(DEPARTEMENT_PROPERTY, event.getCodeDepartment());
        map.set(VILLE_PROPERTY, event.getCity());
        map.set(DATE_DEBUT_INSCRIPTION_PROPERTY, event.getStartDateRegistration());
        map.set(DATE_FIN_INSCRIPTION_PROPERTY, event.getEndDateRegistration());
        map.set(URL_INSCRIPTION_PROPERTY, event.getUrlRegistration());
        map.set(IMPORTED_PROPERTY, true);
        return map;
    }
    
	private String formatDate(Date date)
	{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		return sdf.format(date);
	}

    /**
     * {@inheritDoc}
     */
    @Override
    public String getId() {
        return "Calendar/" + this.contextPath;
    }

}