package fr.toutatice.services.calendar.event.edition.portlet.configuration;

import javax.annotation.PostConstruct;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;

import org.osivia.services.calendar.event.edition.portlet.configuration.CalendarEventEditionConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

/**
 * Calendar event edition portlet configuration.
 *
 * @author Julien Barberet
 */
@Configuration
@ComponentScan(basePackages = {"org.osivia.services.calendar.common", "org.osivia.services.calendar.event.edition.portlet", "fr.toutatice.services.calendar.event.edition.portlet", "fr.toutatice.services.calendar.common"})
public class InteractikCalendarEventEditionConfiguration extends CalendarEventEditionConfiguration {


    /** Portlet config. */
    @Autowired
    protected PortletConfig portletConfig;
	
    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionConfiguration() {
        super();
    }
    
    /**
     * Post-construct.
     *
     * @throws PortletException
     */
    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }
	
    /**
     * {@inheritDoc}
     */
    @Bean(name = "messageSource")
    @Override
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames("interactik", "calendar-event-edition", "calendar-common", "Resource");
        return messageSource;
    }
}
