package fr.toutatice.services.calendar.event.edition.portlet.model.validation;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.apache.commons.lang.StringUtils;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.event.edition.portlet.model.validation.CalendarEventEditionFormValidator;
import org.osivia.services.calendar.event.edition.portlet.service.CalendarEventEditionService;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;

/**
 * Calendar event edition form validator.
 * 
 * @author Julien Barberet
 * @see Validator
 */
@Component
@Primary
public class InteractikCalendarEventEditionFormValidator extends CalendarEventEditionFormValidator {

    /** Date format. */
    private final DateFormat dateFormat;


    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionFormValidator() {
        super();

        // Date format
        this.dateFormat = new SimpleDateFormat(CalendarEventEditionService.DATE_FORMAT_PATTERN);
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public boolean supports(Class<?> clazz) {
        return CalendarCommonEventForm.class.isAssignableFrom(clazz);
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void validate(Object target, Errors errors) {
        // Form
         InteractikCalendarEventEditionForm form = (InteractikCalendarEventEditionForm) target;

        super.validate(target, errors);
        
        if (form.isInteractikAgenda())
        {
        
	        //Contrôles liés à Interactik
	        //Département
	        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "departement", "NotEmpty");
	        
	        //Date debut inscription
	        if (StringUtils.isNotBlank(form.getStringDebutInscription())) {
	            try {
	                this.dateFormat.parse(form.getStringDebutInscription());
	            } catch (ParseException e) {
	                errors.rejectValue("stringDebutInscription", "Invalid");
	            }
	        }
	        
	        //Date fin inscription
	        ValidationUtils.rejectIfEmptyOrWhitespace(errors, "stringFinInscription", "NotEmpty");
	        if (StringUtils.isNotBlank(form.getStringFinInscription())) {
	            try {
	                this.dateFormat.parse(form.getStringFinInscription());
	            } catch (ParseException e) {
	                errors.rejectValue("stringFinInscription", "Invalid");
	            }
	        }
        }
        
    }

}
