package fr.toutatice.services.calendar.event.edition.portlet.repository;

import javax.portlet.PortletException;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.repository.CalendarRepositoryImpl;
import org.osivia.services.calendar.event.edition.portlet.repository.CalendarEventEditionRepositoryImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.services.calendar.event.edition.portlet.repository.command.InteractikCalendarEventCreationCommand;
import fr.toutatice.services.calendar.event.edition.portlet.repository.command.InteractikCalendarEventEditionCommand;

/**
 * Calendar repository implementation.
 *
 * @author Cédric Krommenhoek
 * @author Julien Barberet
 * @see CalendarRepositoryImpl
 * @see ToutaticeCalendarEventEditionRepository
 */
@Repository
@Primary
public class InteractikCalendarEventEditionRepositoryImpl extends CalendarEventEditionRepositoryImpl {

    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionRepositoryImpl() {
        super();
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void save(PortalControllerContext portalControllerContext, CalendarEditionOptions options, CalendarCommonEventForm form) throws PortletException {
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);

        // Nuxeo command
        INuxeoCommand command;
        if (options.isCreation()) {
            command = this.applicationContext.getBean(InteractikCalendarEventCreationCommand.class, options, form);
        } else {
            command = this.applicationContext.getBean(InteractikCalendarEventEditionCommand.class, options, form);
        }

        nuxeoController.executeNuxeoCommand(command);
    }

}
