package fr.toutatice.services.calendar.event.edition.portlet.repository.command;

import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DOCUMENT_TYPE_EVENT_INTERACTIK;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DEPARTEMENT_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DOCUMENT_TYPE_EVENT;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.CODE_DEPARTEMENT_ACADEMIE;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;

/**
 * Calendar event creation Nuxeo command.
 * 
 * @author Cédric Krommenhoek
 * @see AbstractInteractikCalendarEventCommand
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InteractikCalendarEventCreationCommand extends AbstractInteractikCalendarEventCommand {


    /** Calendar edition options. */
    private final CalendarEditionOptions options;
    /** Calendar event edition form. */
    private final InteractikCalendarEventEditionForm form;


    /**
     * Constructor.
     * 
     * @param options calendar edition options
     * @param form calendar event edition form
     */
    public InteractikCalendarEventCreationCommand(CalendarEditionOptions options, InteractikCalendarEventEditionForm form) {
        super();
        this.options = options;
        this.form = form;
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public Object execute(Session nuxeoSession) throws Exception {
        // Document service
        DocumentService documentService = nuxeoSession.getAdapter(DocumentService.class);

        // Parent
        DocRef parent = new DocRef(this.options.getParentPath());

        // Properties
        PropertyMap properties = this.getProperties(this.form);

        // Creation
        Document document = documentService.createDocument(parent, form.isInteractikAgenda()? DOCUMENT_TYPE_EVENT_INTERACTIK : DOCUMENT_TYPE_EVENT, null, properties, true);

        // Attachments
        this.setAttachments(documentService, document, this.form);

        return document;
    }

}
