package fr.toutatice.services.calendar.event.view.portlet.configuration;

import org.osivia.services.calendar.event.view.portlet.configuration.CalendarEventViewConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;

/**
 * Toutatice calendar event view portlet configuration.
 *
 * @author Julien Barberet
 */
@Configuration
@ComponentScan(basePackages = {"fr.toutatice.services.calendar.event.view.portlet", "fr.toutatice.services.calendar.common"})
public class InteractikCalendarEventViewConfiguration extends CalendarEventViewConfiguration {

    /**
     * Constructor.
     */
    public InteractikCalendarEventViewConfiguration() {
        super();
    }
    
    /**
     * {@inheritDoc}
     */
    @Bean(name = "messageSource")
    @Override
    public ResourceBundleMessageSource getMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames("interactik", "calendar-common", "calendar-event-edition");
        return messageSource;
    }

}
