package fr.toutatice.services.calendar.event.view.portlet.service;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DEPARTEMENT_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.VILLE_PROPERTY;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DATE_DEBUT_INSCRIPTION_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.DATE_FIN_INSCRIPTION_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.URL_INSCRIPTION_PROPERTY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_VOCABULARY;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.CODE_DEPARTEMENT_ACADEMIE;

import javax.portlet.PortletException;

import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.event.view.portlet.service.CalendarEventViewServiceImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.event.view.portlet.model.InteractikCalendarEventViewForm;

/**
 * Calendar event view portlet service implementation.
 *
 * @author Julien Barberet
 */
@Service
@Primary
public class InteractikCalendarEventViewServiceImpl extends CalendarEventViewServiceImpl {
	
    /**
     * Constructor.
     */
    public InteractikCalendarEventViewServiceImpl() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public InteractikCalendarEventViewForm getForm(PortalControllerContext portalControllerContext) throws PortletException {

        // Calendar event edition form
        InteractikCalendarEventViewForm form = this.applicationContext.getBean(InteractikCalendarEventViewForm.class);

        Document document = this.repository.getCurrentDocument(portalControllerContext);

        form.setDocument(this.dao.toDTO(document));
        form.setTitle(document.getString(TITLE_PROPERTY));

        // All day indicator
        boolean allDay = this.isAllDay(portalControllerContext, document);
        form.setAllDay(allDay);

        form.setStartDate(document.getDate(START_DATE_PROPERTY));
        form.setEndDate(document.getDate(END_DATE_PROPERTY));

        form.setSameDay(this.isSameDay(form));
        form.setEndDateAllDay(this.getEndDateAllDay(form));

        // Location
        String location = this.getLocation(portalControllerContext, document);
        form.setLocation(location);

        // Calendar color
        CalendarColor calendarColor = this.getCalendarColor(portalControllerContext, document);
        // Color
        InteractikCalendarColor color = (InteractikCalendarColor) this.getColor(portalControllerContext, document, calendarColor);
        form.setColor(color);
        
        // Description
        String description = this.getDescription(portalControllerContext, document);
        form.setDescription(description);

        // Attachments
        this.setAttachments(portalControllerContext, document, form);
        
        // Interactik data
        
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        List<String> vocabs = new ArrayList<String>();
        vocabs.add(COOPERATIVE_VOCABULARY);
        VocabularyEntry vocabEntry = VocabularyHelper.getVocabularyEntry(nuxeoController, vocabs, true);
        Map<String, VocabularyEntry> children = vocabEntry.getChildren();
        if (children != null)
        {
	        VocabularyEntry entry = children.get(document.getString(DEPARTEMENT_PROPERTY));
	        if (entry != null) form.setDepartement(entry.getLabel());
        }
        form.setDateDebutInscription(document.getDate(DATE_DEBUT_INSCRIPTION_PROPERTY));
        form.setDateFinInscription(document.getDate(DATE_FIN_INSCRIPTION_PROPERTY));
        form.setVille(document.getString(VILLE_PROPERTY));
        form.setUrlInscription(document.getString(URL_INSCRIPTION_PROPERTY));

        return form;
    }


//    private ToutaticeCalendarColor getCalendarColor(PortalControllerContext portalControllerContext, Document document) throws PortletException {
//        // Nuxeo controller
//        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
//
//        // Calendar path
//        String path;
//
//        // Event path
//        String eventPath = document.getPath();
//
//        path = StringUtils.substringBeforeLast(eventPath, "/");
//
//
//        // Calendar Nuxeo document
//        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
//        Document calendar = documentContext.getDocument();
//
//        // Color identifier
//        String colorId = null;
//        if (calendar != null) {
//            String sourceId = document.getString(ID_PARENT_SOURCE_PROPERTY);
//            if ((sourceId == null) || sourceId.isEmpty()) {
//                colorId = calendar.getString(CALENDAR_COLOR_PROPERTY);
//            } else {
//                PropertyList propertyList = (PropertyList) calendar.getProperties().get(LIST_SOURCE_SYNCHRO);
//                if (propertyList != null) {
//                    for (int i = 0; i < propertyList.size(); i++) {
//                        PropertyMap map = propertyList.getMap(i);
//                        if (sourceId.equals(map.get(SOURCEID_SYNCHRONIZATION))) {
//                            colorId = map.getString(COLOR_SYNCHRONIZATION);
//                            break;
//                        }
//                    }
//                }
//            }
//        }
//
//        return ToutaticeCalendarColor.fromId(colorId);
//    }


    private InteractikCalendarColor getColor(PortalControllerContext portalControllerContext, Document document, CalendarColor calendarColor) throws PortletException {
        // Color identifier
        String colorId;
        if (document == null) {
            colorId = null;
        } else {
            colorId = document.getString(COLOR_PROPERTY);
            if (colorId == null)
            {
                String dept = document.getString(DEPARTEMENT_PROPERTY);
                if (dept != null)
                {
                	if (CODE_DEPARTEMENT_ACADEMIE.equals(dept)) colorId = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
                	else if ("22".equals(dept)) colorId = InteractikCalendarColor.COTE_D_ARMOR.toString();
                	else if ("29".equals(dept)) colorId = InteractikCalendarColor.FINISTERE.toString();
                	else if ("35".equals(dept)) colorId = InteractikCalendarColor.ILE_ET_VILAINE.toString();
                	else if ("53".equals(dept)) colorId = InteractikCalendarColor.MORBIHAN.toString();
                }
            }
        }

        if ((colorId == null) && (calendarColor != null)) {
            colorId = calendarColor.getId();
        }

        return InteractikCalendarColor.fromId(colorId);
    }

}
