/*
 * (C) Copyright 2014 Académie de Rennes (http://www.ac-rennes.fr/), OSIVIA (http://www.osivia.com) and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 *
 *
 */
package fr.toutatice.services.calendar.plugin;

import java.util.List;
import java.util.Map;

import javax.portlet.PortletContext;

import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.customization.Plugin;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.portal.api.player.IPlayerModule;
import org.osivia.services.calendar.plugin.CalendarPlayer;
import org.osivia.services.calendar.plugin.CalendarPlugin;
import org.springframework.context.annotation.Primary;

import fr.toutatice.portail.cms.nuxeo.api.domain.AbstractPluginPortlet;
import fr.toutatice.services.calendar.plugin.menubar.InteractikCalendarMenubarModule;

/**
 * Add integration in toutatice-cms: define Calendar and calendar events, enable calendar to be played with the specific player.
 *
 * @author Julien Barberet
 * @see AbstractPluginPortlet
 */
@Plugin("calendar.plugin")
@Primary
public class InteractikCalendarPlugin extends CalendarPlugin  {

    /**
     * Constructor.
     */
    public InteractikCalendarPlugin() {
        super();
    }

    /**
     * Customize menubar modules.
     *
     * @param context customization context
     */
    @Override
    public void customizeMenubarModules(CustomizationContext context) {
        // Menubar modules
        List<MenubarModule> modules = this.getMenubarModules(context);

        // Calendar menubar module
        MenubarModule calendar = new InteractikCalendarMenubarModule();
        modules.add(calendar);
    }
    
    /**
     * Customize players.
     *
     * @param context customize players
     */
    @Override
    protected void customizePlayers(CustomizationContext context) {
        // Portlet context
        PortletContext portletContext = this.getPortletContext();

        // Players
        @SuppressWarnings("rawtypes")
        List<IPlayerModule> players = this.getPlayers(context);

        // Calendar player
        CalendarPlayer calendar = new InteractikCalendarPlayer(portletContext);
        players.add(calendar);
    }
    
    /**
     * Customize document types.
    *
    * @param context customization context
    */
   @Override
   protected void customizeDocumentTypes(CustomizationContext context) {
       // Document types
       Map<String, DocumentType> types = this.getDocTypes(context);

       // Calendar event
       DocumentType event = DocumentType.createNode("VEVENT");
       event.setIcon("glyphicons glyphicons-important-day");
       event.setForceContextualization(true);
       event.setEditable(true);
       types.put(event.getName(), event);
       
       // Calendar event interactik
       DocumentType eventInteractik = DocumentType.createNode("VEVENTInteractik");
       eventInteractik.setIcon("glyphicons glyphicons-important-day");
       eventInteractik.setForceContextualization(true);
       eventInteractik.setEditable(true);
       types.put(eventInteractik.getName(), eventInteractik);

       // Calendar
       DocumentType calendar = DocumentType.createNode("Agenda");
       calendar.addSubtypes(event.getName());
       calendar.setIcon("glyphicons glyphicons-calendar");
       calendar.setBrowsable(false);
       calendar.setForceContextualization(true);
       calendar.setEditable(true);
       types.put(calendar.getName(), calendar);
       
       // Calendar interactik
       DocumentType calendarInteractik = DocumentType.createNode("AgendaInteractik");
       calendarInteractik.addSubtypes(eventInteractik.getName());
       calendarInteractik.setIcon("glyphicons glyphicons-calendar");
       calendarInteractik.setBrowsable(false);
       calendarInteractik.setForceContextualization(true);
       calendarInteractik.setEditable(true);
       types.put(calendarInteractik.getName(), calendarInteractik);
   }

}
