package fr.toutatice.services.calendar.plugin.menubar;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.IMPORTED_PROPERTY;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.portlet.PortletException;

import org.jboss.portal.theme.impl.render.dynamic.DynaRenderOptions;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.Constants;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.cms.DocumentContext;
import org.osivia.portal.api.cms.DocumentType;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.menubar.MenubarModule;
import org.osivia.services.calendar.edition.portlet.service.CalendarEditionService;
import org.osivia.services.calendar.plugin.menubar.CalendarMenubarModule;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;

/**
 * Calendar menubar module.
 *
 * @author Julien Barberet
 * @see MenubarModule
 */
public class InteractikCalendarMenubarModule extends CalendarMenubarModule implements MenubarModule {
	
    /** Interactik Calendar Nuxeo document type name. */
	protected static final String CALENDAR_INTERACTIK_TYPE = "AgendaInteractik";
	/** Calendar interactik event Nuxeo document type name. */
	protected static final String EVENT_INTERACTIK_TYPE = "VEVENTInteractik";
    /** Add calendar menubar item identifier. */
    protected static final String ADD_CALENDAR_INTERACTIK_MENUBAR_ITEM_ID = ADD_MENUBAR_ITEM_ID + "_" + CALENDAR_INTERACTIK_TYPE;
    /** Add calendar event menubar item identifier. */
    protected static final String ADD_EVENT_INTERACTIK_MENUBAR_ITEM_ID = ADD_MENUBAR_ITEM_ID + "_" + EVENT_INTERACTIK_TYPE;
	
    /**
     * Constructor.
     */
    public InteractikCalendarMenubarModule() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void customizeDocument(PortalControllerContext portalControllerContext, List<MenubarItem> menubar, DocumentContext documentContext)
            throws PortalException {
        if (documentContext != null) {
            // Document type
            DocumentType documentType = documentContext.getDocumentType();

            if (documentType != null) {
                // Document
                Document document = (Document) documentContext.getDocument();

                MenubarItem addCalendar = null;
                MenubarItem addCalendarInteractik = null;
                MenubarItem addEvent = null;
                MenubarItem addEventInteractik = null;
                MenubarItem editCalendar = null;
                MenubarItem editCalendarInteractik = null;
                MenubarItem editEvent = null;
                MenubarItem editEventInteractik = null;

                for (MenubarItem menubarItem : menubar) {
                    if (ADD_CALENDAR_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        addCalendar = menubarItem;
                    } else if (ADD_CALENDAR_INTERACTIK_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                    	addCalendarInteractik = menubarItem;
                    } else if (ADD_EVENT_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        addEvent = menubarItem;
                    } else if (ADD_EVENT_INTERACTIK_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        addEventInteractik = menubarItem;
                    } else if (ADD_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        if (CALENDAR_TYPE.equals(documentType.getName())) {
                            addEvent = menubarItem;
                        } else if(CALENDAR_INTERACTIK_TYPE.equals(documentType.getName())) {
                        	addEventInteractik = menubarItem;
                        }
                    } else if (EDIT_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
                        if (CALENDAR_TYPE.equals(documentType.getName())) {
                            editCalendar = menubarItem;
                        } else if (CALENDAR_INTERACTIK_TYPE.equals(documentType.getName())) {
                        	editCalendarInteractik = menubarItem;
                        } else if (EVENT_TYPE.equals(documentType.getName())) {
                            editEvent = menubarItem;
                        } else if (EVENT_INTERACTIK_TYPE.equals(documentType.getName())) {
                            editEventInteractik = menubarItem;
                        }
                    }
                }

                if (addCalendar != null) {
                    this.customizeMenubarItem(portalControllerContext, addCalendar, document, CALENDAR_TYPE, true);
                }
                if (addCalendarInteractik != null) {
                    this.customizeMenubarItem(portalControllerContext, addCalendarInteractik, document, CALENDAR_INTERACTIK_TYPE, true);
                }
                if (addEvent != null) {
                    this.customizeMenubarItem(portalControllerContext, addEvent, document, EVENT_TYPE, true);
                }
                if (addEventInteractik != null) {
                    this.customizeMenubarItem(portalControllerContext, addEventInteractik, document, EVENT_INTERACTIK_TYPE, true);
                }
                if (editCalendar != null) {
                    this.customizeMenubarItem(portalControllerContext, editCalendar, document, CALENDAR_TYPE, false);
                }
                if (editCalendarInteractik != null) {
                    this.customizeMenubarItem(portalControllerContext, editCalendarInteractik, document, CALENDAR_INTERACTIK_TYPE, false);
                }
                if (editEvent != null) { 
                    this.customizeMenubarItem(portalControllerContext, editEvent, document, EVENT_TYPE, false);
                }
                if (editEventInteractik != null) { 
                    this.customizeMenubarItem(portalControllerContext, editEventInteractik, document, EVENT_INTERACTIK_TYPE, false);
                }

                // If event came from synchronization, disable edit and delete options
                if (document.getString(ID_EVENT_SOURCE_PROPERTY) != null && !document.getString(ID_EVENT_SOURCE_PROPERTY).isEmpty()) {
                    try {
						this.removeEditAndDelete(menubar, documentType, document, portalControllerContext);
					} catch (PortletException e) {
						throw new PortalException(e);
					}
                }
            }
        }
    }

    @Override
    protected void customizeMenubarItem(PortalControllerContext portalControllerContext, MenubarItem item, Document document, String documentType,
            boolean creation) throws PortalException {
        // Portlet instance
        String instance;

        // Window properties
        Map<String, String> properties = new HashMap<>();
        properties.put(Constants.WINDOW_PROP_URI, document.getPath());
        properties.put(DynaRenderOptions.PARTIAL_REFRESH_ENABLED, String.valueOf(true));
        properties.put("osivia.ajaxLink", "1");

        // Creation indicator
        properties.put(CalendarEditionService.CREATION_PROPERTY, String.valueOf(creation));

        if (CALENDAR_TYPE.equals(documentType) || CALENDAR_INTERACTIK_TYPE.equals(documentType)) {
            // Calendar edition
            instance = CALENDAR_EDITION_PORTLET_INSTANCE;
        } else if (EVENT_TYPE.equals(documentType) || EVENT_INTERACTIK_TYPE.equals(documentType)) {
            // Calendar event edition
            instance = EVENT_EDITION_PORTLET_INSTANCE;
        } else {
            // Unknown case
            instance = null;
        }

        // URL
        String url;
        if (instance == null) {
            url = null;
        } else {
            url = this.portalUrlFactory.getStartPortletUrl(portalControllerContext, instance, properties);
        }


        // Update menubar item
        item.setUrl(url);
        item.setOnclick(null);
        item.setHtmlClasses(null);
    }
    
    /**
     * Remove edit and delete menubar item.
     * 
     * @param menubar menubar
     * @param documentType document type
     * @throws PortletException 
     */
    @Override
    public void removeEditAndDelete(List<MenubarItem> menubar, DocumentType documentType, Document document, PortalControllerContext portalControllerContext) throws PortletException {
        if ((documentType != null) && (EVENT_TYPE.equals(documentType.getName()) || EVENT_INTERACTIK_TYPE.equals(documentType.getName()))) {
            Set<MenubarItem> removedItems = new HashSet<>();
            boolean isInInteractikAgenda = isInteractikAgenda(document, portalControllerContext);
            boolean isImportedInteractikAgenda = isImportedInteractikAgenda(document);
            for (MenubarItem menubarItem : menubar) {
            	if (isInInteractikAgenda)
            	{
            		if (isImportedInteractikAgenda)
            		{
		                if (EDIT_MENUBAR_ITEM_ID.equals(menubarItem.getId()) || DELETE_MENUBAR_ITEM_ID.equals(menubarItem.getId())) {
		                    removedItems.add(menubarItem);
		                }
	            	}
            	}
            }
            menubar.removeAll(removedItems);
        }
    }

    
	private boolean isInteractikAgenda(Document document, PortalControllerContext portalControllerContext) throws PortletException {
		// Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        
        String parentPath = NuxeoController.getParentPath(document.getPath());
        
        // Nuxeo document context
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(parentPath);
        
        Document documentParent = documentContext.getDocument();
        
		return AGENDA_INTERACTIK.equals(documentParent.getType());
	}
	
	private boolean isImportedInteractikAgenda(Document document) throws PortletException {
        
        String imported = document.getString(IMPORTED_PROPERTY);
        boolean isImported = false;
        if (imported != null)
        {
        	isImported = new Boolean(imported).booleanValue();
        }
        
        
		return isImported;
	}
}
