package fr.toutatice.services.calendar.view.portlet.service.generator;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_22;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_29;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_35;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_56;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.COOPERATIVE_ACADEMIE;
import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;

import java.util.List;

import javax.portlet.PortletException;
import javax.portlet.PortletRequest;

import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;


/**
 * Calendar generator implementation super-class.
 *
 * @author Julien Barberet
 * @see ICalendarGenerator
 */
public abstract class InteractikCalendarGeneratorImpl extends CalendarGeneratorImpl implements ICalendarGenerator {
    
    /** Calendar repository. */
    @Autowired
    private CalendarViewRepository calendarRepository;
	
	/**
     * Constructor.
     */
    public InteractikCalendarGeneratorImpl() {
        super();
    }

    
    /**
     * {@inheritDoc}
     */
    @Override
    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        CalendarData calendarData = new InteractikCalendarData();
        // Period type
        calendarData.setPeriodType(periodType);
        // Cooperatives
        // By default, all cooperatives are set to true 
        ((InteractikCalendarData) calendarData).setCooperativeCA(true);
        ((InteractikCalendarData) calendarData).setCooperativeFI(true);
        ((InteractikCalendarData) calendarData).setCooperativeIV(true);
        ((InteractikCalendarData) calendarData).setCooperativeMO(true);
        ((InteractikCalendarData) calendarData).setCooperativeAcademie(true);
        // Generator
        calendarData.setGenerator(this);
        // Dates
        this.fillCalendarDates(portalControllerContext, calendarData, null);
        
        //Is interactik agenda?
	    Document document = getCurrentDocument(portalControllerContext);
	    boolean agendaInteractik = false;
	    if (document != null)
	    {
	    	agendaInteractik = AGENDA_INTERACTIK.equals(document.getType());
	    }
	    ((InteractikCalendarData) calendarData).setAgendaInteractik(agendaInteractik);

        return calendarData;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
    	
    	if (((InteractikCalendarData) calendarData).isAgendaInteractik())
    	{
	    	PortletRequest request = portalControllerContext.getRequest();
	    	request.setAttribute(COOPERATIVE_22, ((InteractikCalendarData) calendarData).isCooperativeCA());
	    	request.setAttribute(COOPERATIVE_29, ((InteractikCalendarData) calendarData).isCooperativeFI());
	    	request.setAttribute(COOPERATIVE_35, ((InteractikCalendarData) calendarData).isCooperativeIV());
	    	request.setAttribute(COOPERATIVE_56, ((InteractikCalendarData) calendarData).isCooperativeMO());
	    	request.setAttribute(COOPERATIVE_ACADEMIE, ((InteractikCalendarData) calendarData).isCooperativeAcademie());
	    	request.setAttribute(AGENDA_INTERACTIK, ((InteractikCalendarData) calendarData).isAgendaInteractik());
	    	
	    	// Events
	        List<Event> events = this.calendarRepository.getEvents(portalControllerContext, calendarData.getStartDate(), calendarData.getEndDate());
	
	        // Events data
	        EventsData eventsData;
	        if (events == null) {
	            eventsData = null;
	        } else {
	            eventsData = this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
	        }
	
	        return eventsData;
    	} else 
    	{
    		return super.generateEventsData(portalControllerContext, calendarData);
    	}
    }
    

    private Document getCurrentDocument(PortalControllerContext portalControllerContext) throws PortletException {
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);

        // Nuxeo document context
        NuxeoDocumentContext documentContext = nuxeoController.getCurrentDocumentContext();

        // Nuxeo document
        Document document;
        if (documentContext == null) {
            document = null;
        } else {
            document = documentContext.getDocument();
        }

        return document;
    }
}
