/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.edition.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.services.calendar.edition.portlet.model.EventFromExcel;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class InteractikImportEventsFromExcelCommand
implements INuxeoCommand {
    private final String contextPath;
    private List<EventFromExcel> eventsList;
    private final String parentPath;
    protected static final Log logger = LogFactory.getLog(InteractikImportEventsFromExcelCommand.class);

    public InteractikImportEventsFromExcelCommand(String contextPath, String parentPath, List<EventFromExcel> eventsList) {
        this.contextPath = contextPath;
        this.eventsList = eventsList;
        this.parentPath = parentPath;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        for (EventFromExcel eventToCreate : this.eventsList) {
            PropertyMap map = this.fillMap(eventToCreate);
            documentService.createDocument(new DocRef(this.parentPath), "VEVENTInteractik", null, map, true);
        }
        return null;
    }

    private PropertyMap fillMap(EventFromExcel event) throws JsonGenerationException, JsonMappingException, IOException {
        PropertyMap map = new PropertyMap();
        if (event.isAllDay()) {
            map.set("vevent:dtend", this.formatDate(event.getEndDate()));
            map.set("vevent:dtstart", this.formatDate(event.getStartDate()));
        } else {
            map.set("vevent:dtend", event.getEndDate());
            map.set("vevent:dtstart", event.getStartDate());
        }
        map.set("dc:title", event.getTitle());
        map.set("note:note", event.getDescription());
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getDefault());
        map.set("sync:created", cal.getTime());
        map.set("sync:lastModified", cal.getTime());
        map.set("vevent:allDay", Boolean.valueOf(event.isAllDay()));
        map.set("vevent:location", event.getLocation());
        map.set("ttctik:departement", event.getCodeDepartment());
        map.set("ttctik:ville", event.getCity());
        map.set("ttctik:datedebutinscription", event.getStartDateRegistration());
        map.set("ttctik:datefininscription", event.getEndDateRegistration());
        map.set("ttctik:urlInscription", event.getUrlRegistration());
        map.set("ttctik:imported", Boolean.valueOf(true));
        return map;
    }

    private String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public String getId() {
        return "Calendar/" + this.contextPath;
    }
}

