/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.event.edition.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.api.cms.NuxeoDocumentContext;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.common.model.converter.InteractikCalendarColorPropertyEditor;
import fr.toutatice.services.calendar.common.repository.InteractikCalendarEventRepository;
import fr.toutatice.services.calendar.event.edition.portlet.model.Image;
import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;
import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventVocabularies;
import fr.toutatice.services.calendar.event.edition.portlet.repository.InteractikCalendarEventEditionRepository;
import fr.toutatice.services.calendar.event.edition.portlet.service.InteractikCalendarEventEditionService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.portlet.PortletException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.services.calendar.common.model.Attachments;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.model.CalendarEventDates;
import org.osivia.services.calendar.common.model.converter.CalendarColorPropertyEditor;
import org.osivia.services.calendar.event.edition.portlet.service.CalendarEventEditionServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Primary
public class InteractikCalendarEventEditionServiceImpl
extends CalendarEventEditionServiceImpl
implements InteractikCalendarEventEditionService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private InteractikCalendarEventEditionRepository repository;
    @Autowired
    private InteractikCalendarEventRepository commonRepository;
    @Autowired
    private DocumentDAO dao;
    @Autowired
    private InteractikCalendarColorPropertyEditor calendarColorPropertyEditor;
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");

    public CalendarCommonEventForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        CalendarEditionOptions options = this.getEditionOptions(portalControllerContext);
        InteractikCalendarEventEditionForm form = (InteractikCalendarEventEditionForm)this.applicationContext.getBean(InteractikCalendarEventEditionForm.class);
        Document document = options.getDocument();
        if (document != null) {
            form.setDocument(this.dao.toDTO(document));
        } else {
            form.setDocument(null);
        }
        CalendarColor calendarColor = this.getCalendarColor(portalControllerContext, options);
        form.setCalendarColor(calendarColor);
        String title = this.repository.getTitle(portalControllerContext, document);
        form.setTitle(title);
        boolean allDay = this.repository.isAllDay(portalControllerContext, document);
        form.setAllDay(allDay);
        CalendarEventDates dates = this.repository.getDates(portalControllerContext, document, allDay);
        form.setDates(dates);
        this.updateFormDates((CalendarCommonEventForm)form);
        form.setSameDay(this.isSameDay(form));
        form.setEndDateAllDay(this.getEndDateAllDay(form));
        String location = this.repository.getLocation(portalControllerContext, document);
        form.setLocation(location);
        InteractikCalendarColor color = this.getColor(portalControllerContext, document, calendarColor);
        form.setColor(color);
        String description = this.repository.getDescription(portalControllerContext, document);
        form.setDescription(description);
        Attachments attachments = this.repository.getAttachments(portalControllerContext, document);
        form.setAttachments(attachments);
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        ArrayList<String> vocabs = new ArrayList<String>();
        vocabs.add("cooperative");
        VocabularyEntry vocabEntry = VocabularyHelper.getVocabularyEntry((NuxeoController)nuxeoController, vocabs, (Boolean)true);
        Map children = vocabEntry.getChildren();
        if (children != null) {
            Collection childrenValues = children.values();
            TreeMap<String, String> mapCooperative = new TreeMap<String, String>();
            for (VocabularyEntry entry : childrenValues) {
                mapCooperative.put(entry.getId(), entry.getLabel());
            }
            form.setMapCooperative(mapCooperative);
        }
        if (document != null) {
            form.setDepartement(document.getString("ttctik:departement"));
            this.setDateInscription(form, document);
            form.setVille(document.getString("ttctik:ville"));
            form.setUrlInscription(document.getString("ttctik:urlInscription"));
            PropertyMap pageVignette = document.getProperties().getMap("ttc:vignette");
            if (pageVignette != null) {
                ICMSService cmsService = this.cmsServiceLocator.getCMSService();
                CMSServiceCtx cmsContext = new CMSServiceCtx();
                cmsContext.setPortalControllerContext(portalControllerContext);
                Image visual = (Image)this.applicationContext.getBean(Image.class);
                try {
                    visual.setUrl(this.createFileLink(cmsService, cmsContext, document, "ttc:vignette"));
                    form.setVisual(visual);
                }
                catch (CMSException e) {
                    e.printStackTrace();
                }
            }
            if (StringUtils.isNotEmpty((String)document.getString("ttctik:imported"))) {
                form.setImported(new Boolean(document.getString("ttctik:imported")).booleanValue());
            } else {
                form.setImported(false);
            }
        }
        this.commonRepository.fillInteractikEventProperties(portalControllerContext, document, form.getInteractik());
        return form;
    }

    public CalendarColorPropertyEditor getCalendarColorPropertyEditor() {
        return this.calendarColorPropertyEditor;
    }

    private void setDateInscription(InteractikCalendarEventEditionForm form, Document document) {
        Date endDate;
        Date startDate;
        if (document == null) {
            startDate = null;
            endDate = null;
        } else {
            startDate = document.getDate("ttctik:datedebutinscription");
            endDate = document.getDate("ttctik:datefininscription");
        }
        if (startDate != null) {
            form.setStringDebutInscription(this.dateFormat.format(startDate));
        } else {
            form.setStringDebutInscription(null);
        }
        if (endDate != null) {
            form.setStringFinInscription(this.dateFormat.format(endDate));
        } else {
            form.setStringFinInscription(null);
        }
        form.setDateDebutInscription(startDate);
        form.setDateFinInscription(endDate);
    }

    protected CalendarColor getCalendarColor(PortalControllerContext portalControllerContext, CalendarEditionOptions options) throws PortletException {
        String path;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        if (options.isCreation()) {
            path = options.getParentPath();
        } else {
            String eventPath = options.getDocument().getPath();
            path = StringUtils.substringBeforeLast((String)eventPath, (String)"/");
        }
        NuxeoDocumentContext documentContext = nuxeoController.getDocumentContext(path);
        Document calendar = documentContext.getDocument();
        return this.getCalendarColor(portalControllerContext, calendar);
    }

    private InteractikCalendarColor getColor(PortalControllerContext portalControllerContext, Document document, CalendarColor calendarColor) throws PortletException {
        String colorId;
        if (document == null) {
            colorId = null;
        } else {
            String dept;
            colorId = document.getString("vevent:color");
            if (colorId == null && (dept = document.getString("ttctik:departement")) != null) {
                if ("aca".equals(dept)) {
                    colorId = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
                } else if ("22".equals(dept)) {
                    colorId = InteractikCalendarColor.COTE_D_ARMOR.toString();
                } else if ("29".equals(dept)) {
                    colorId = InteractikCalendarColor.FINISTERE.toString();
                } else if ("35".equals(dept)) {
                    colorId = InteractikCalendarColor.ILE_ET_VILAINE.toString();
                } else if ("53".equals(dept)) {
                    colorId = InteractikCalendarColor.MORBIHAN.toString();
                }
            }
        }
        if (colorId == null && calendarColor != null) {
            colorId = calendarColor.getId();
        }
        return InteractikCalendarColor.fromId((String)colorId);
    }

    private Date getEndDateAllDay(InteractikCalendarEventEditionForm form) {
        if (form.getEndDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(form.getEndDate());
            cal.add(5, -1);
            return cal.getTime();
        }
        return null;
    }

    private boolean isSameDay(InteractikCalendarEventEditionForm form) {
        boolean sameDay = false;
        Calendar calStart = Calendar.getInstance();
        Calendar calEnd = Calendar.getInstance();
        calStart.setTime(form.getStartDate());
        calEnd.setTime(form.getEndDate());
        if (form.isAllDay()) {
            long diff = 0L;
            diff = Math.round((calEnd.getTime().getTime() - calStart.getTime().getTime()) / 86400000L);
            sameDay = diff <= 1L;
        } else {
            calStart.set(11, 0);
            calStart.set(12, 0);
            calStart.set(13, 0);
            calStart.set(14, 0);
            calEnd.set(11, 0);
            calEnd.set(12, 0);
            calEnd.set(13, 0);
            calEnd.set(14, 0);
            sameDay = this.dateFormat.format(calStart.getTime()).equals(this.dateFormat.format(calEnd.getTime()));
        }
        return sameDay;
    }

    public InteractikCalendarEventVocabularies getVocabularies(PortalControllerContext portalControllerContext) throws PortletException {
        InteractikCalendarEventVocabularies vocabularies = (InteractikCalendarEventVocabularies)this.applicationContext.getBean(InteractikCalendarEventVocabularies.class);
        if (!vocabularies.isInitialized()) {
            this.repository.initializeVocabularies(portalControllerContext, vocabularies);
        }
        return vocabularies;
    }

    public void uploadVisual(PortalControllerContext portalControllerContext, InteractikCalendarEventEditionForm form) throws PortletException, IOException {
        Image visual = form.getVisual();
        visual.setUpdated(true);
        visual.setDeleted(false);
        MultipartFile upload = visual.getUpload();
        File temporaryFile = File.createTempFile("visual-", ".tmp");
        temporaryFile.deleteOnExit();
        upload.transferTo(temporaryFile);
        visual.setTemporaryFile(temporaryFile);
        form.setVisual(visual);
    }

    public void deleteVisual(PortalControllerContext portalControllerContext, InteractikCalendarEventEditionForm form) throws PortletException {
        Image visual = form.getVisual();
        visual.setUpdated(false);
        visual.setDeleted(true);
    }

    public String createFileLink(ICMSService cmsService, CMSServiceCtx cmsContext, Document doc, String fieldName) throws CMSException {
        BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, doc.getPath());
        binary.setFieldName(fieldName);
        binary.setDocument((Object)doc);
        return cmsService.getBinaryResourceURL(cmsContext, binary).getUrl();
    }
}

