/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.edition.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletException;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.repository.CalendarRepositoryImpl;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.edition.portlet.model.Picture;
import org.osivia.services.calendar.edition.portlet.repository.CalendarEditionRepository;
import org.osivia.services.calendar.edition.portlet.repository.command.CalendarCreationCommand;
import org.osivia.services.calendar.edition.portlet.repository.command.CalendarEditionCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Repository;

@Repository
public class CalendarEditionRepositoryImpl
extends CalendarRepositoryImpl
implements CalendarEditionRepository {
    @Autowired
    private ApplicationContext applicationContext;

    public String getDescription(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        String description = document == null ? null : document.getString("dc:description");
        return description;
    }

    public Picture getVignette(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        PropertyMap propertyMap;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        Picture vignette = (Picture)this.applicationContext.getBean(Picture.class);
        if (document != null && (propertyMap = document.getProperties().getMap("ttc:vignette")) != null && !propertyMap.isEmpty()) {
            String url = nuxeoController.createFileLink(document, "ttc:vignette");
            vignette.setUrl(url);
        }
        return vignette;
    }

    public List<CalendarSynchronizationSource> getSynchronizationSources(PortalControllerContext portalControllerContext, Document document) throws PortletException {
        ArrayList<Object> sources;
        if (document == null) {
            sources = new ArrayList<CalendarSynchronizationSource>(0);
        } else {
            PropertyList propertyList = document.getProperties().getList("cal:sources");
            if (propertyList == null) {
                sources = new ArrayList(0);
            } else {
                sources = new ArrayList(propertyList.size());
                for (int i = 0; i < propertyList.size(); ++i) {
                    PropertyMap propertyMap = propertyList.getMap(i);
                    CalendarSynchronizationSource source = (CalendarSynchronizationSource)this.applicationContext.getBean(CalendarSynchronizationSource.class);
                    String id = propertyMap.getString("sourceId");
                    source.setId(id);
                    String url = propertyMap.getString("url");
                    source.setUrl(url);
                    String colorId = propertyMap.getString("color");
                    source.setColor(CalendarColor.fromId((String)colorId));
                    String displayName = propertyMap.getString("displayName");
                    source.setDisplayName(displayName);
                    sources.add(source);
                }
            }
        }
        return sources;
    }

    public void save(PortalControllerContext portalControllerContext, CalendarEditionOptions options, CalendarEditionForm form) throws PortletException {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        INuxeoCommand command = options.isCreation() ? (INuxeoCommand)this.applicationContext.getBean(CalendarCreationCommand.class, new Object[]{options, form}) : (INuxeoCommand)this.applicationContext.getBean(CalendarEditionCommand.class, new Object[]{options, form});
        nuxeoController.executeNuxeoCommand(command);
    }
}

