/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.edition.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.NuxeoPropertyList;
import org.nuxeo.ecm.automation.client.model.NuxeoPropertyMap;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.edition.portlet.model.Picture;

public abstract class AbstractCalendarCommand
implements INuxeoCommand {
    public String getId() {
        return null;
    }

    protected PropertyMap getProperties(CalendarEditionForm form) {
        String colorId = form.getColor() == null ? null : form.getColor().getId();
        String synchronizationSources = this.getSynchronizationSourcesProperty(form.getSynchronizationSources());
        PropertyMap properties = new PropertyMap();
        properties.set("dc:title", form.getTitle());
        properties.set("dc:description", form.getDescription());
        properties.set("cal:color", colorId);
        properties.set("cal:sources", synchronizationSources);
        return properties;
    }

    private String getSynchronizationSourcesProperty(List<CalendarSynchronizationSource> sources) {
        String property;
        if (CollectionUtils.isEmpty(sources)) {
            property = null;
        } else {
            NuxeoPropertyList propertyList = new NuxeoPropertyList(sources.size());
            for (CalendarSynchronizationSource source : sources) {
                NuxeoPropertyMap propertyMap = new NuxeoPropertyMap();
                String id = source.getId();
                propertyMap.put("sourceId", (Object)id);
                String url = StringUtils.trimToNull((String)source.getUrl());
                propertyMap.put("url", (Object)url);
                String colorId = source.getColor() == null ? null : source.getColor().getId();
                propertyMap.put("color", (Object)colorId);
                String displayName = StringUtils.trimToNull((String)source.getDisplayName());
                propertyMap.put("displayName", (Object)displayName);
                propertyList.add((PropertyMap)propertyMap);
            }
            property = propertyList.toString();
        }
        return property;
    }

    protected void setVignette(DocumentService documentService, Document document, CalendarEditionForm form) throws Exception {
        Picture vignette = form.getVignette();
        File temporaryFile = vignette.getTemporaryFile();
        if (temporaryFile != null) {
            String fileName = vignette.getTemporaryFileName();
            String mimeType = vignette.getTemporaryMimeType().getBaseType();
            FileBlob blob = new FileBlob(temporaryFile, fileName, mimeType);
            documentService.setBlob((DocRef)document, (Blob)blob, "ttc:vignette");
            temporaryFile.delete();
        } else if (vignette.isDeleted()) {
            documentService.removeBlob((DocRef)document, "ttc:vignette");
        }
    }
}

