/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.event.view.portlet.service;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.services.calendar.common.model.InteractikCalendarColor;
import fr.toutatice.services.calendar.common.repository.InteractikCalendarEventRepository;
import fr.toutatice.services.calendar.event.view.portlet.model.InteractikCalendarEventViewForm;
import fr.toutatice.services.calendar.event.view.portlet.service.InteractikCalendarEventViewService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.http.client.utils.URIBuilder;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.event.view.portlet.model.CalendarEventViewForm;
import org.osivia.services.calendar.event.view.portlet.service.CalendarEventViewServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class InteractikCalendarEventViewServiceImpl
extends CalendarEventViewServiceImpl
implements InteractikCalendarEventViewService {
    @Autowired
    private InteractikCalendarEventRepository commonRepository;
    @Autowired
    private IBundleFactory bundleFactory;
    private final String facebookAppId;
    private final ICMSServiceLocator cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");

    public InteractikCalendarEventViewServiceImpl() {
        this.facebookAppId = System.getProperty("acrennes.sites.interactik.facebook.app.id");
    }

    public InteractikCalendarEventViewForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        URIBuilder builder;
        URL url;
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        PortletRequest request = portalControllerContext.getRequest();
        Locale locale = request.getLocale();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        InteractikCalendarEventViewForm form = (InteractikCalendarEventViewForm)this.applicationContext.getBean(InteractikCalendarEventViewForm.class);
        Document document = this.repository.getCurrentDocument(portalControllerContext);
        PropertyMap documentProperties = document.getProperties();
        form.setDocument(this.dao.toDTO(document));
        form.setTitle(document.getString("dc:title"));
        boolean allDay = this.isAllDay(portalControllerContext, document);
        form.setAllDay(allDay);
        form.setStartDate(document.getDate("vevent:dtstart"));
        form.setEndDate(document.getDate("vevent:dtend"));
        form.setSameDay(this.isSameDay((CalendarEventViewForm)form));
        form.setEndDateAllDay(this.getEndDateAllDay((CalendarEventViewForm)form));
        String location = this.getLocation(portalControllerContext, document);
        form.setLocation(location);
        CalendarColor calendarColor = this.getCalendarColor(portalControllerContext, document);
        InteractikCalendarColor color = this.getColor(portalControllerContext, document, calendarColor);
        form.setColor((Enum)color);
        String description = this.getDescription(portalControllerContext, document);
        form.setDescription(description);
        this.setAttachments(portalControllerContext, document, (CalendarEventViewForm)form);
        DateFormat titleDateFormat = DateFormat.getDateInstance(1, locale);
        if (allDay) {
            titleDateFormat.setTimeZone(DateUtils.UTC_TIME_ZONE);
        } else {
            titleDateFormat.setTimeZone(TimeZone.getDefault());
        }
        Date start = document.getDate("vevent:dtstart");
        Date end = document.getDate("vevent:dtend");
        if (allDay) {
            end = DateUtils.addDays((Date)end, (int)-1);
        }
        StringBuilder formattedDate = new StringBuilder();
        StringBuilder formattedTime = new StringBuilder();
        formattedDate.append(titleDateFormat.format(start));
        if (DateUtils.isSameDay((Date)start, (Date)end)) {
            if (BooleanUtils.toBoolean((Boolean)documentProperties.getBoolean("vevent:allDay"))) {
                formattedTime.append(bundle.getString("CALENDAR_EVENT_ALL_DAY"));
            } else {
                Calendar startCalendar = Calendar.getInstance();
                startCalendar.setTime(start);
                int startHour = startCalendar.get(11);
                formattedTime.append(String.valueOf(startHour));
                formattedTime.append("h");
                int startMinute = startCalendar.get(12);
                if (startMinute != 0) {
                    formattedTime.append(StringUtils.leftPad((String)String.valueOf(startMinute), (int)2, (String)"0"));
                }
                formattedTime.append(" > ");
                Calendar endCalendar = Calendar.getInstance();
                endCalendar.setTime(end);
                int endHour = endCalendar.get(11);
                formattedTime.append(String.valueOf(endHour));
                formattedTime.append("h");
                int endMinute = endCalendar.get(12);
                if (endMinute != 0) {
                    formattedTime.append(StringUtils.leftPad((String)String.valueOf(endMinute), (int)2, (String)"0"));
                }
            }
        } else {
            formattedDate.append(" > ");
            formattedDate.append(titleDateFormat.format(end));
        }
        form.setFormattedDate(formattedDate.toString());
        form.setFormattedTime(formattedTime.toString());
        String webId = document.getString("ttc:webid");
        String path = StringUtils.isEmpty((String)webId) ? StringUtils.removeEnd((String)document.getPath(), (String)".proxy") : NuxeoController.webIdToCmsPath((String)webId);
        String permalink = nuxeoController.createPermalink(path);
        try {
            url = new URL("https", "twitter.com", "/intent/tweet");
            builder = new URIBuilder(url.toURI());
            builder.setParameter("url", permalink);
            form.setTwitterUrl(builder.toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new PortletException((Throwable)e);
        }
        try {
            url = new URL("https", "www.facebook.com", "/dialog/share");
            builder = new URIBuilder(url.toURI());
            builder.setParameter("app_id", this.facebookAppId);
            builder.setParameter("display", "page");
            builder.setParameter("href", permalink);
            builder.setParameter("redirect_uri", permalink);
            form.setFacebookUrl(builder.toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new PortletException((Throwable)e);
        }
        try {
            url = new URL("https", "Linkedin.com", "/shareArticle");
            builder = new URIBuilder(url.toURI());
            builder.setParameter("url", permalink);
            form.setLinkedinUrl(builder.toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new PortletException((Throwable)e);
        }
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        String pictureUrl = null;
        PropertyMap pageVignette = document.getProperties().getMap("ttc:vignette");
        if (pageVignette != null) {
            try {
                pictureUrl = this.createFileLink(cmsService, cmsContext, document, "ttc:vignette");
            }
            catch (CMSException e) {
                e.printStackTrace();
            }
        } else {
            String departement = document.getString("ttctik:departement");
            String pictureWebId = "resultat-evt-" + departement;
            String picturePath = NuxeoController.webIdToFetchPath((String)pictureWebId);
            pictureUrl = nuxeoController.createPictureLink(picturePath, "Original");
        }
        form.setPictureUrl(pictureUrl);
        this.commonRepository.fillInteractikEventProperties(portalControllerContext, document, form.getInteractik());
        return form;
    }

    private InteractikCalendarColor getColor(PortalControllerContext portalControllerContext, Document document, CalendarColor calendarColor) throws PortletException {
        String colorId;
        if (document == null) {
            colorId = null;
        } else {
            String dept;
            colorId = document.getString("vevent:color");
            if (colorId == null && (dept = document.getString("ttctik:departement")) != null) {
                if ("aca".equals(dept)) {
                    colorId = InteractikCalendarColor.ACADEMIE_BRETAGNE.toString();
                } else if ("22".equals(dept)) {
                    colorId = InteractikCalendarColor.COTE_D_ARMOR.toString();
                } else if ("29".equals(dept)) {
                    colorId = InteractikCalendarColor.FINISTERE.toString();
                } else if ("35".equals(dept)) {
                    colorId = InteractikCalendarColor.ILE_ET_VILAINE.toString();
                } else if ("53".equals(dept)) {
                    colorId = InteractikCalendarColor.MORBIHAN.toString();
                }
            }
        }
        if (colorId == null && calendarColor != null) {
            colorId = calendarColor.getId();
        }
        return InteractikCalendarColor.fromId((String)colorId);
    }

    public String createFileLink(ICMSService cmsService, CMSServiceCtx cmsContext, Document doc, String fieldName) throws CMSException {
        BinaryDescription binary = new BinaryDescription(BinaryDescription.Type.FILE, doc.getPath());
        binary.setFieldName(fieldName);
        binary.setDocument((Object)doc);
        return cmsService.getBinaryResourceURL(cmsContext, binary).getUrl();
    }
}

