/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.repository.command;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.Date;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.services.calendar.view.portlet.model.CalendarEditionMode;
import org.osivia.services.calendar.view.portlet.model.CalendarViewForm;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class InteractikEventEditionCommand
implements INuxeoCommand {
    private final CalendarViewForm form;

    public InteractikEventEditionCommand(CalendarViewForm form) {
        this.form = form;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        CalendarEditionMode mode = this.form.getMode();
        Object document = CalendarEditionMode.CREATION.equals((Object)mode) ? this.create(nuxeoSession) : (CalendarEditionMode.EDITION.equals((Object)mode) ? this.edit(nuxeoSession) : null);
        return document;
    }

    public String getId() {
        return null;
    }

    private Document create(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocRef parent = new DocRef(this.form.getParentPath());
        PropertyMap properties = new PropertyMap();
        properties.set("vevent:dtend", this.convertWithTimezone(this.form.getEndDate()));
        properties.set("vevent:dtstart", this.convertWithTimezone(this.form.getStartDate()));
        properties.set("dc:title", this.form.getTitle());
        properties.set("ttctik:departement", "aca");
        Document document = documentService.createDocument(parent, "VEVENTInteractik", null, properties, true);
        return document;
    }

    private Date convertWithTimezone(Date date) {
        return date;
    }

    private Document edit(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocRef docRef = new DocRef(this.form.getDocId());
        PropertyMap map = new PropertyMap();
        map.set("vevent:dtend", this.convertWithTimezone(this.form.getEndDate()));
        map.set("vevent:dtstart", this.convertWithTimezone(this.form.getStartDate()));
        map.set("dc:title", this.form.getTitle());
        Document document = documentService.update(docRef, map, true);
        return document;
    }
}

