/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.service;

import fr.toutatice.services.calendar.view.portlet.model.events.InteractikEvent;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.portlet.PortletException;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.service.CalendarIntegrationService;
import org.osivia.services.calendar.view.portlet.service.CalendarIntegrationServiceImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class InteractikCalendarIntegrationServiceImpl
extends CalendarIntegrationServiceImpl
implements CalendarIntegrationService {
    private final DateFormat inscriptionDateFormat = new SimpleDateFormat("yyyyMMdd");

    protected VEvent createVEvent(PortalControllerContext portalControllerContext, Event event) throws PortletException, IOException {
        VEvent vevent = super.createVEvent(portalControllerContext, event);
        PropertyList properties = vevent.getProperties();
        if (event instanceof InteractikEvent) {
            InteractikEvent interactikEvent = (InteractikEvent)event;
            if (StringUtils.isNotEmpty((String)interactikEvent.getDepartement())) {
                XProperty departement = new XProperty("X-DEPARTEMENT", interactikEvent.getDepartement());
                properties.add((Property)departement);
            }
            if (StringUtils.isNotEmpty((String)interactikEvent.getVille())) {
                XProperty ville = new XProperty("X-VILLE", interactikEvent.getVille());
                properties.add((Property)ville);
            }
            if (StringUtils.isNotEmpty((String)interactikEvent.getUrlInscription())) {
                XProperty urlInscription = new XProperty("X-URLINSCRIPTION", interactikEvent.getUrlInscription());
                properties.add((Property)urlInscription);
            }
            if (interactikEvent.getDebutInscription() != null) {
                XProperty debutInscription = new XProperty("X-DATE_DEBUT_INSCRIPTION", this.inscriptionDateFormat.format(interactikEvent.getDebutInscription()));
                properties.add((Property)debutInscription);
            }
            if (interactikEvent.getFinInscription() != null) {
                XProperty finInscription = new XProperty("X-DATE_FIN_INSCRIPTION", this.inscriptionDateFormat.format(interactikEvent.getFinInscription()));
                properties.add((Property)finInscription);
            }
            this.addMultipleProperties(properties, "X-ORGANISATEUR_INTERACTIK", interactikEvent.getOrganisateurs());
            this.addMultipleProperties(properties, "X-POLE_INTERACTIK", interactikEvent.getPolesDisciplinaires());
            this.addMultipleProperties(properties, "X-THEME_INTERACTIK", interactikEvent.getThemes());
            this.addMultipleProperties(properties, "X-NIVEAU_INTERACTIK", interactikEvent.getNiveaux());
            this.addMultipleProperties(properties, "X-CONTENU_INTERACTIK", interactikEvent.getContenus());
            this.addMultipleProperties(properties, "X-REPERE_DNE_INTERACTIK", interactikEvent.getReperesDne());
        }
        return vevent;
    }

    private void addMultipleProperties(PropertyList properties, String name, List<String> values) {
        if (CollectionUtils.isNotEmpty(values)) {
            for (String value : values) {
                XProperty property = new XProperty(name, value);
                properties.add((Property)property);
            }
        }
    }
}

