/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.calendar.view.portlet.service.generator;

import fr.toutatice.services.calendar.view.portlet.model.Cooperative;
import fr.toutatice.services.calendar.view.portlet.model.InteractikCalendarOptions;
import fr.toutatice.services.calendar.view.portlet.model.InteractikFilters;
import fr.toutatice.services.calendar.view.portlet.model.calendar.InteractikCalendarData;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.CalendarOptions;
import org.osivia.services.calendar.view.portlet.model.calendar.CalendarData;
import org.osivia.services.calendar.view.portlet.model.events.EventsData;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.generator.CalendarGeneratorImpl;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class InteractikCalendarGeneratorImpl
extends CalendarGeneratorImpl
implements ICalendarGenerator {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CalendarViewRepository calendarRepository;

    public CalendarData generateCalendarData(PortalControllerContext portalControllerContext, PeriodTypes periodType) throws PortletException {
        CalendarData calendarData = super.generateCalendarData(portalControllerContext, periodType);
        CalendarOptions options = this.calendarRepository.getConfiguration(portalControllerContext);
        if (calendarData instanceof InteractikCalendarData && options instanceof InteractikCalendarOptions) {
            InteractikCalendarData interactikCalendarData = (InteractikCalendarData)calendarData;
            InteractikCalendarOptions interactikOptions = (InteractikCalendarOptions)options;
            Cooperative selectedCooperative = interactikOptions.getSelectedCooperative();
            if (selectedCooperative == null || !selectedCooperative.isDisplayed()) {
                interactikCalendarData.setDisplayCooperatives(true);
            } else {
                InteractikFilters filters = interactikCalendarData.getFilters();
                if (filters == null) {
                    filters = (InteractikFilters)this.applicationContext.getBean(InteractikFilters.class);
                    interactikCalendarData.setFilters(filters);
                }
                try {
                    PropertyUtils.setSimpleProperty((Object)filters, (String)selectedCooperative.getProperty(), (Object)true);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new PortletException((Throwable)e);
                }
                interactikCalendarData.setDisplayCooperatives(false);
            }
            interactikCalendarData.setCooperatives(new ArrayList<Cooperative>(Arrays.asList(Cooperative.values())));
        }
        return calendarData;
    }

    public EventsData generateEventsData(PortalControllerContext portalControllerContext, CalendarData calendarData) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        request.setAttribute("cooperative22", (Object)request.getParameter("cooperative22"));
        request.setAttribute("cooperative29", (Object)request.getParameter("cooperative29"));
        request.setAttribute("cooperative35", (Object)request.getParameter("cooperative35"));
        request.setAttribute("cooperative56", (Object)request.getParameter("cooperative56"));
        request.setAttribute("cooperativeAcademie", (Object)request.getParameter("cooperativeAcademie"));
        request.setAttribute("AgendaInteractik", (Object)true);
        List events = this.calendarRepository.getEvents(portalControllerContext, calendarData.getStartDate(), calendarData.getEndDate());
        EventsData eventsData = events == null ? null : this.generateSpecializedEventsData(portalControllerContext, calendarData, events);
        return eventsData;
    }
}

