/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.model.calendar;

import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.osivia.services.calendar.view.portlet.service.CalendarViewService;
import org.osivia.services.calendar.view.portlet.service.generator.ICalendarGenerator;
import org.osivia.services.calendar.view.portlet.utils.PeriodTypes;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CalendarData {
    private PeriodTypes periodType;
    private ICalendarGenerator generator;
    private Date selectedDate;
    private Date startDate;
    private Date endDate;
    private String scrollViewDayWeek;
    private String scrollViewMonth;
    private String agendaBackgroundColor;
    private boolean readOnly;

    public PeriodTypes getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(PeriodTypes periodType) {
        this.periodType = periodType;
    }

    public ICalendarGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(ICalendarGenerator generator) {
        this.generator = generator;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Date selectedDate) {
        this.selectedDate = selectedDate;
    }

    public String getScrollViewDayWeek() {
        return this.scrollViewDayWeek;
    }

    public void setScrollViewDayWeek(String scrollViewDayWeek) {
        this.scrollViewDayWeek = scrollViewDayWeek;
    }

    public String getScrollViewMonth() {
        return this.scrollViewMonth;
    }

    public void setScrollViewMonth(String scrollViewMonth) {
        this.scrollViewMonth = scrollViewMonth;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getStartDateToString() {
        if (this.startDate != null) {
            return CalendarViewService.SELECTED_DATE_FORMAT.format(this.startDate);
        }
        return null;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            if (PeriodTypes.DAY == this.periodType) {
                this.endDate = DateUtils.addDays((Date)this.startDate, (int)1);
            } else if (PeriodTypes.WEEK == this.periodType) {
                this.endDate = DateUtils.addDays((Date)this.startDate, (int)7);
            } else if (PeriodTypes.MONTH == this.periodType) {
                this.endDate = DateUtils.addMonths((Date)this.startDate, (int)1);
            }
        }
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getAgendaBackgroundColor() {
        return this.agendaBackgroundColor;
    }

    public void setAgendaBackgroundColor(String agendaBackgroundColor) {
        this.agendaBackgroundColor = agendaBackgroundColor;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

