/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.calendar.view.portlet.service;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.portlet.PortletException;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.view.portlet.model.events.Event;
import org.osivia.services.calendar.view.portlet.repository.CalendarViewRepository;
import org.osivia.services.calendar.view.portlet.service.CalendarIntegrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CalendarIntegrationServiceImpl
implements CalendarIntegrationService {
    private final ProdId prodId = new ProdId("-//OSIVIA Portal//4.7//FR");
    @Autowired
    private CalendarViewRepository repository;

    public void integrate(PortalControllerContext portalControllerContext, OutputStream outputStream, String format) throws PortletException, IOException {
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)this.prodId);
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        List events = this.repository.getEvents(portalControllerContext, null, null);
        if (CollectionUtils.isNotEmpty((Collection)events)) {
            for (Event event : events) {
                VEvent vevent = this.createVEvent(portalControllerContext, event);
                if (vevent == null) continue;
                calendar.getComponents().add((Object)vevent);
            }
        }
        CalendarOutputter outputter = new CalendarOutputter();
        outputter.output(calendar, outputStream);
    }

    protected VEvent createVEvent(PortalControllerContext portalControllerContext, Event event) throws PortletException, IOException {
        VEvent vevent;
        Date start;
        if (event.getStartDate() == null) {
            start = null;
        } else if (event.isAllDay()) {
            start = new Date(event.getStartDate());
        } else {
            DateTime dateTime = new DateTime(event.getStartDate());
            dateTime.setUtc(true);
            start = dateTime;
        }
        String summary = event.getTitle();
        if (start != null && StringUtils.isNotEmpty((String)summary)) {
            vevent = new VEvent(start, summary);
            PropertyList properties = vevent.getProperties();
            if (event.getEndDate() != null) {
                DtEnd end;
                if (event.isAllDay()) {
                    end = new DtEnd(new Date(event.getEndDate()));
                } else {
                    end = new DtEnd((Date)new DateTime(event.getEndDate()));
                    end.setUtc(true);
                }
                properties.add((Property)end);
            }
            if (StringUtils.isNotEmpty((String)event.getId())) {
                Uid uid = new Uid(event.getId());
                properties.add((Property)uid);
            }
            if (event.getLastModified() != null) {
                LastModified lastModified = new LastModified(new DateTime(event.getLastModified()));
                properties.add((Property)lastModified);
            }
            if (StringUtils.isNotBlank((String)event.getLocation())) {
                Location location = new Location(event.getLocation());
                properties.add((Property)location);
            }
            if (StringUtils.isNotBlank((String)event.getDescription())) {
                Description description = new Description(event.getDescription());
                properties.add((Property)description);
            }
        } else {
            vevent = null;
        }
        return vevent;
    }
}

