package fr.toutatice.services.calendar.edition.portlet.service;

import static fr.toutatice.services.calendar.common.InteractikCalendarConstant.AGENDA_INTERACTIK;

import java.util.List;

import javax.portlet.PortletException;

import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarColor;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.common.service.CalendarServiceImpl;
import org.osivia.services.calendar.edition.portlet.model.CalendarEditionForm;
import org.osivia.services.calendar.edition.portlet.model.CalendarSynchronizationSource;
import org.osivia.services.calendar.edition.portlet.model.Picture;
import org.osivia.services.calendar.edition.portlet.service.CalendarEditionService;
import org.osivia.services.calendar.edition.portlet.service.CalendarEditionServiceImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import fr.toutatice.services.calendar.edition.portlet.model.InteractikCalendarEditionForm;

/**
 * Interactik calendar edition portlet service implementation.
 * 
 * @author Julien Barberet
 * @see CalendarServiceImpl
 * @see CalendarEditionService
 */
@Service
@Primary
public class InteractikCalendarEditionServiceImpl extends CalendarEditionServiceImpl{

    /**
     * Constructor.
     */
    public InteractikCalendarEditionServiceImpl() {
        super();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CalendarEditionForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        // Calendar edition options
        CalendarEditionOptions options = this.getEditionOptions(portalControllerContext);
        // Calendar form
        CalendarEditionForm form = this.applicationContext.getBean(InteractikCalendarEditionForm.class);

        // Nuxeo document
        Document document = options.getDocument();
        
        //Agenda interactik
        boolean agendaInteractik = false;
	    if (document != null)
	    {
	    	agendaInteractik = AGENDA_INTERACTIK.equals(document.getType());
	    }
	    ((InteractikCalendarEditionForm) form).setAgendaInteractik(agendaInteractik);

        // Title
        String title = this.repository.getTitle(portalControllerContext, document);
        form.setTitle(title);

        // Description
        String description = this.repository.getDescription(portalControllerContext, document);
        form.setDescription(description);

        // Vignette
        Picture vignette = this.repository.getVignette(portalControllerContext, document);
        form.setVignette(vignette);

        // Color
        CalendarColor color = getCalendarColor(portalControllerContext, document);
        form.setColor(color);

        // Synchronization sources
        List<CalendarSynchronizationSource> sources = this.repository.getSynchronizationSources(portalControllerContext, document);
        form.setSynchronizationSources(sources);
        
        return form;
    }



}
