package fr.toutatice.services.calendar.event.edition.portlet.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.CharEncoding;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.event.edition.portlet.controller.CalendarEventEditionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;
import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventVocabularies;
import fr.toutatice.services.calendar.event.edition.portlet.service.InteractikCalendarEventEditionService;

/**
 * Interactik calendar event edition portlet controller.
 *
 * @author Cédric Krommenhoek
 * @see CalendarEventEditionController
 */
@Controller
@RequestMapping("VIEW")
@Primary
public class InteractikCalendarEventEditionController extends CalendarEventEditionController {

    /** Portlet context. */
    @Autowired
    private PortletContext portletContext;

    /** Portlet service. */
    @Autowired
    private InteractikCalendarEventEditionService service;

    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionController() {
        super();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @ModelAttribute("options") CalendarEditionOptions options) throws PortletException {
        super.view(request, response, options);

        return "view-interactik";
    }


    /**
     * Get vocabularies model attribute.
     * 
     * @param request portlet request
     * @param response portlet response
     * @return vocabularies
     * @throws PortletException
     */
    @ModelAttribute("vocabularies")
    public InteractikCalendarEventVocabularies getVocabularies(PortletRequest request, PortletResponse response) throws PortletException {
        // Portal controller context
        PortalControllerContext portalControllerContext = new PortalControllerContext(portletContext, request, response);
        
        return this.service.getVocabularies(portalControllerContext);
    }

    /**
     * Upload visual action mapping.
     * 
     * @param request action request
     * @param response action response
     * @param form workspace edition form model attribute
     * @throws PortletException
     * @throws IOException
     */
    @ActionMapping(name = "save", params = "upload-visual")
    public void uploadVisual(ActionRequest request, ActionResponse response, @ModelAttribute("form") InteractikCalendarEventEditionForm form)
            throws PortletException, IOException {
        // Portal controller context
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);

        this.service.uploadVisual(portalControllerContext, form);
    }


    /**
     * Delete visual action mapping.
     * 
     * @param request action request
     * @param response action response
     * @param form workspace edition form model attribute
     * @throws PortletException
     */
    @ActionMapping(name = "save", params = "delete-visual")
    public void deleteVisual(ActionRequest request, ActionResponse response, @ModelAttribute("form") InteractikCalendarEventEditionForm form)
            throws PortletException {
        // Portal controller context
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);

        this.service.deleteVisual(portalControllerContext, form);
    }

    /**
     * Visual preview resource mapping.
     * 
     * @param request resource request
     * @param response resource response
     * @param form workspace edition form model attribute
     * @throws IOException
     */
    @ResourceMapping("visualPreview")
    public void visualPreview(ResourceRequest request, ResourceResponse response, @ModelAttribute("form") InteractikCalendarEventEditionForm form)
            throws IOException {
    	
        // Temporary file
        File temporaryFile = form.getVisual().getTemporaryFile();

        // Upload size
        Long size = new Long(temporaryFile.length());
        response.setContentLength(size.intValue());

        // Content type
        String contentType = response.getContentType();
        response.setContentType(contentType);

        // Character encoding
        response.setCharacterEncoding(CharEncoding.UTF_8);

        // No cache
        response.getCacheControl().setExpirationTime(0);

        // Input steam
        InputStream inputSteam = new FileInputStream(temporaryFile);
        // Output stream
        OutputStream outputStream = response.getPortletOutputStream();
        // Copy
        IOUtils.copy(inputSteam, outputStream);
        outputStream.close();
    }    
    
}
