package fr.toutatice.services.calendar.event.edition.portlet.repository;

import java.util.LinkedHashMap;
import java.util.Map;

import javax.portlet.PortletException;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.common.model.CalendarCommonEventForm;
import org.osivia.services.calendar.common.model.CalendarEditionOptions;
import org.osivia.services.calendar.event.edition.portlet.repository.CalendarEventEditionRepositoryImpl;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventVocabularies;
import fr.toutatice.services.calendar.event.edition.portlet.repository.command.InteractikCalendarEventCreationCommand;
import fr.toutatice.services.calendar.event.edition.portlet.repository.command.InteractikCalendarEventEditionCommand;

/**
 * Calendar repository implementation.
 *
 * @author Cédric Krommenhoek
 * @author Julien Barberet
 * @see CalendarEventEditionRepositoryImpl
 * @see InteractikCalendarEventEditionRepository
 */
@Repository
@Primary
public class InteractikCalendarEventEditionRepositoryImpl extends CalendarEventEditionRepositoryImpl implements InteractikCalendarEventEditionRepository {

    /**
     * Constructor.
     */
    public InteractikCalendarEventEditionRepositoryImpl() {
        super();
    }
    
    /**
     * {@inheritDoc}
     */
    @Override
    public void save(PortalControllerContext portalControllerContext, CalendarEditionOptions options, CalendarCommonEventForm form) throws PortletException {
        // Nuxeo controller
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);

        // Nuxeo command
        INuxeoCommand command;
        if (options.isCreation()) {
            command = this.applicationContext.getBean(InteractikCalendarEventCreationCommand.class, options, form);
        } else {
            command = this.applicationContext.getBean(InteractikCalendarEventEditionCommand.class, options, form);
        }

        nuxeoController.executeNuxeoCommand(command);
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public synchronized void initializeVocabularies(PortalControllerContext portalControllerContext, InteractikCalendarEventVocabularies vocabularies) throws PortletException {
        if (!vocabularies.isInitialized()) {
            // Nuxeo controller
            NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
            
            // Organisateurs
            Map<String, String> organisateurs = this.getVocabulary(nuxeoController, ORGANISATEURS_VOCABULARY_NAME);
            vocabularies.setOrganisateurs(organisateurs);
            // Pôles disciplinaires
            Map<String, String> polesDisciplinaires = this.getVocabulary(nuxeoController, POLES_DISCIPLINAIRES_VOCABULARY_NAME);
            vocabularies.setPolesDisciplinaires(polesDisciplinaires);
            // Thèmes
            Map<String, String> themes = this.getVocabulary(nuxeoController, THEMES_VOCABULARY_NAME);
            vocabularies.setThemes(themes);
            // Niveaux
            Map<String, String> niveaux = this.getVocabulary(nuxeoController, NIVEAUX_VOCABULARY_NAME);
            vocabularies.setNiveaux(niveaux);
            // Contenus
            Map<String, String> contenus = this.getVocabulary(nuxeoController, CONTENUS_VOCABULARY_NAME);
            vocabularies.setContenus(contenus);
            // Repères DNE
            Map<String, String> reperesDne = this.getVocabulary(nuxeoController, REPERES_DNE_VOCABULARY_NAME);
            vocabularies.setReperesDne(reperesDne);
            
            vocabularies.setInitialized(true);
        }
    }


    /**
     * Get vocabulary.
     * 
     * @param nuxeoController Nuxeo controller
     * @param vocabularyName vocabulary name
     * @return vocabulary map
     */
    private Map<String, String> getVocabulary(NuxeoController nuxeoController, String vocabularyName) {
        // Vocabulary entries
        Map<String, VocabularyEntry> entries = VocabularyHelper.getVocabularyEntry(nuxeoController, vocabularyName).getChildren();

        // Vocabulary map
        Map<String, String> map = new LinkedHashMap<>(entries.size());
        for (VocabularyEntry entry : entries.values()) {
            String id = entry.getId();
            String label = entry.getLabel();
            map.put(id, label);
        }

        return map;
    }

}
