package fr.toutatice.services.calendar.event.edition.portlet.service;

import java.io.IOException;

import javax.portlet.PortletException;

import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.calendar.event.edition.portlet.service.CalendarEventEditionService;

import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventEditionForm;
import fr.toutatice.services.calendar.event.edition.portlet.model.InteractikCalendarEventVocabularies;

/**
 * Interactik calendar event edition portlet service interface.
 * 
 * @author Cédric Krommenhoek
 * @see CalendarEventEditionService
 */
public interface InteractikCalendarEventEditionService extends CalendarEventEditionService {

    /**
     * Get vocabularies.
     * 
     * @param portalControllerContext portal controller context
     * @return vocabularies
     * @throws PortletException
     */
    InteractikCalendarEventVocabularies getVocabularies(PortalControllerContext portalControllerContext) throws PortletException;
    /**
     * Upload visual.
     * 
     * @param portalControllerContext portal controller context
     * @param form InteractikCalendarEventEditionForm 
     * @throws PortletException
     * @throws IOException
     */
    void uploadVisual(PortalControllerContext portalControllerContext, InteractikCalendarEventEditionForm form) throws PortletException, IOException;


    /**
     * Delete visual.
     * 
     * @param portalControllerContext portal controller context
     * @param form InteractikCalendarEventEditionForm 
     * @throws PortletException
     */
    void deleteVisual(PortalControllerContext portalControllerContext, InteractikCalendarEventEditionForm form) throws PortletException;    
   
}
